/*
 * Decompiled with CFR 0.152.
 */
package nl.crashdata.chartjs.data.simple.builder;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import nl.crashdata.chartjs.data.simple.SimpleChartJsData;
import nl.crashdata.chartjs.data.simple.builder.SimpleChartJsBuilder;
import nl.crashdata.chartjs.data.simple.builder.SimpleChartJsDatasetBuilder;

public class SimpleChartJsDataBuilder<V extends Serializable>
implements SimpleChartJsBuilder<SimpleChartJsData<V>> {
    private List<SimpleChartJsDatasetBuilder<V>> datasets = new ArrayList<SimpleChartJsDatasetBuilder<V>>();
    private List<String> labels = null;

    @Override
    public boolean isValid() {
        return this.datasets.stream().allMatch(SimpleChartJsBuilder::isValid);
    }

    public SimpleChartJsDatasetBuilder<V> addDataset() {
        SimpleChartJsDatasetBuilder dataset = new SimpleChartJsDatasetBuilder();
        this.datasets.add(dataset);
        return dataset;
    }

    public SimpleChartJsDataBuilder<V> withDatasets(List<SimpleChartJsDatasetBuilder<V>> datasets) {
        this.datasets = datasets;
        return this;
    }

    public SimpleChartJsDataBuilder<V> withLabels(List<String> labels) {
        this.labels = labels;
        return this;
    }

    @Override
    public SimpleChartJsData<V> build() throws IllegalStateException {
        if (!this.isValid()) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " is not ready to build!");
        }
        SimpleChartJsData ret = new SimpleChartJsData();
        ret.setDatasets(this.datasets.stream().map(SimpleChartJsBuilder::build).collect(Collectors.toList()));
        ret.setLabels(this.labels);
        return ret;
    }
}

