/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.xml.bind.JAXB;
import no.digipost.api.client.ApiService;
import no.digipost.api.client.Cached;
import no.digipost.api.client.Communicator;
import no.digipost.api.client.EventLogger;
import no.digipost.api.client.SenderId;
import no.digipost.api.client.errorhandling.DigipostClientException;
import no.digipost.api.client.errorhandling.ErrorCode;
import no.digipost.api.client.representations.Autocomplete;
import no.digipost.api.client.representations.Document;
import no.digipost.api.client.representations.EntryPoint;
import no.digipost.api.client.representations.ErrorMessage;
import no.digipost.api.client.representations.Identification;
import no.digipost.api.client.representations.Link;
import no.digipost.api.client.representations.MayHaveSender;
import no.digipost.api.client.representations.Message;
import no.digipost.api.client.representations.MessageDelivery;
import no.digipost.api.client.representations.Recipients;
import no.digipost.api.client.representations.inbox.Inbox;
import no.digipost.api.client.representations.inbox.InboxDocument;
import no.digipost.api.client.representations.sender.AuthorialSender;
import no.digipost.api.client.representations.sender.SenderInformation;
import no.digipost.api.client.util.ExceptionUtils;
import no.digipost.api.client.util.HttpClientUtils;
import no.digipost.api.client.util.JAXBContextUtils;
import no.digipost.api.client.util.MultipartNoLengthCheckHttpEntity;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpCoreContext;

public class ApiServiceImpl
implements ApiService {
    private static final String ENTRY_POINT = "/";
    private final long brokerId;
    private CloseableHttpClient httpClient;
    private final URI digipostUrl;
    private final RequestConfig config;
    private final HttpClientBuilder httpClientBuilder;
    private final Cached cached;
    private final EventLogger eventLogger;
    private static final DateTimeFormatter DATE_TIME_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSxxx");

    public ApiServiceImpl(HttpClientBuilder httpClientBuilder, long senderAccountId, EventLogger eventLogger, URI digipostUrl, HttpHost proxy) {
        this.brokerId = senderAccountId;
        this.eventLogger = eventLogger;
        this.digipostUrl = digipostUrl;
        this.config = proxy != null ? RequestConfig.custom().setProxy(proxy).build() : null;
        this.httpClientBuilder = httpClientBuilder;
        this.cached = new Cached(this::fetchEntryPoint);
    }

    @Override
    public EntryPoint getEntryPoint() {
        return (EntryPoint)this.cached.entryPoint.get();
    }

    @Override
    public CloseableHttpResponse multipartMessage(HttpEntity multipart) {
        MultipartNoLengthCheckHttpEntity multipartLengthCheckHttpEntity = new MultipartNoLengthCheckHttpEntity(multipart);
        EntryPoint entryPoint = this.getEntryPoint();
        HttpPost httpPost = new HttpPost(this.digipostUrl.resolve(entryPoint.getCreateMessageUri().getPath()));
        httpPost.setHeader("Accept", "application/vnd.digipost-v7+xml");
        httpPost.setHeader("MIME-Version", "1.0");
        httpPost.removeHeaders("Accept-Encoding");
        httpPost.setEntity((HttpEntity)multipartLengthCheckHttpEntity);
        return this.send((HttpRequestBase)httpPost);
    }

    @Override
    public CloseableHttpResponse identifyAndGetEncryptionKey(Identification identification) {
        EntryPoint entryPoint = this.getEntryPoint();
        HttpPost httpPost = new HttpPost(this.digipostUrl.resolve(entryPoint.getIdentificationWithEncryptionKeyUri().getPath()));
        httpPost.setHeader("Accept", "application/vnd.digipost-v7+xml");
        httpPost.setHeader("Content-Type", "application/vnd.digipost-v7+xml");
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        JAXBContextUtils.marshal(JAXBContextUtils.identificationContext, identification, (OutputStream)bao);
        httpPost.setEntity((HttpEntity)new ByteArrayEntity(bao.toByteArray()));
        return this.send((HttpRequestBase)httpPost);
    }

    @Override
    public CloseableHttpResponse createMessage(Message message) {
        EntryPoint entryPoint = this.getEntryPoint();
        HttpPost httpPost = new HttpPost(this.digipostUrl.resolve(entryPoint.getCreateMessageUri().getPath()));
        httpPost.setHeader("Accept", "application/vnd.digipost-v7+xml");
        httpPost.setHeader("Content-Type", "application/vnd.digipost-v7+xml");
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        JAXBContextUtils.marshal(JAXBContextUtils.messageContext, message, (OutputStream)bao);
        httpPost.setEntity((HttpEntity)new ByteArrayEntity(bao.toByteArray()));
        return this.send((HttpRequestBase)httpPost);
    }

    @Override
    public CloseableHttpResponse fetchExistingMessage(URI location) {
        HttpGet httpGet = new HttpGet(this.digipostUrl.resolve(location.getPath()));
        httpGet.setHeader("Accept", "application/vnd.digipost-v7+xml");
        return this.send((HttpRequestBase)httpGet);
    }

    @Override
    public CloseableHttpResponse getEncryptionKey(URI location) {
        HttpGet httpGet = new HttpGet(location);
        httpGet.setHeader("Accept", "application/vnd.digipost-v7+xml");
        return this.send((HttpRequestBase)httpGet);
    }

    @Override
    public CloseableHttpResponse getEncryptionKeyForPrint() {
        EntryPoint entryPoint = this.getEntryPoint();
        HttpGet httpGet = new HttpGet(this.digipostUrl.resolve(entryPoint.getPrintEncryptionKey().getPath()));
        httpGet.setHeader("Accept", "application/vnd.digipost-v7+xml");
        return this.send((HttpRequestBase)httpGet);
    }

    @Override
    public CloseableHttpResponse addContent(Document document, InputStream letterContent) {
        Link addContentLink = this.fetchAddContentLink(document);
        byte[] content = this.readLetterContent(letterContent);
        HttpPost httpPost = new HttpPost(this.digipostUrl.resolve(addContentLink.getUri().getPath()));
        httpPost.setHeader("Accept", "application/vnd.digipost-v7+xml");
        httpPost.setHeader("Content-Type", ContentType.APPLICATION_OCTET_STREAM.toString());
        httpPost.setEntity((HttpEntity)new ByteArrayEntity(content));
        return this.send((HttpRequestBase)httpPost);
    }

    @Override
    public CloseableHttpResponse send(MessageDelivery createdMessage) {
        Link sendLink = this.fetchSendLink(createdMessage);
        HttpPost httpPost = new HttpPost(this.digipostUrl.resolve(sendLink.getUri().getPath()));
        httpPost.setHeader("Accept", "application/vnd.digipost-v7+xml");
        httpPost.setEntity(null);
        return this.send((HttpRequestBase)httpPost);
    }

    private Link fetchAddContentLink(Document document) {
        Link addContentLink = document.getAddContentLink();
        if (addContentLink == null) {
            throw new DigipostClientException(ErrorCode.PROBLEM_WITH_REQUEST, "Kan ikke legge til innhold til et dokument som ikke har en link for \u00e5 gj\u00f8re dette.");
        }
        return addContentLink;
    }

    private Link fetchSendLink(MessageDelivery delivery) {
        Link sendLink = delivery.getSendLink();
        if (sendLink == null) {
            throw new DigipostClientException(ErrorCode.PROBLEM_WITH_REQUEST, "Kan ikke sende en forsendelse som ikke har en link for \u00e5 gj\u00f8re dette.");
        }
        return sendLink;
    }

    byte[] readLetterContent(InputStream letterContent) {
        try {
            return IOUtils.toByteArray((InputStream)letterContent);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CloseableHttpResponse getDocumentEvents(String organisation, String partId, ZonedDateTime from, ZonedDateTime to, int offset, int maxResults) {
        URIBuilder builder = new URIBuilder(this.digipostUrl.resolve(this.getEntryPoint().getDocumentEventsUri().getPath())).setParameter("from", DATE_TIME_FORMAT.format(from)).setParameter("to", DATE_TIME_FORMAT.format(to)).setParameter("offset", String.valueOf(offset)).setParameter("maxResults", String.valueOf(maxResults));
        if (organisation != null) {
            builder = builder.setParameter("org", organisation);
        }
        if (partId != null) {
            builder = builder.setParameter("part", partId);
        }
        try {
            HttpGet httpGet = new HttpGet(builder.build());
            httpGet.setHeader("Accept", "application/vnd.digipost-v7+xml");
            return this.send((HttpRequestBase)httpGet);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public CloseableHttpResponse getDocumentStatus(Link linkToDocumentStatus) {
        return this.getDocumentStatus(linkToDocumentStatus.getUri().getPath());
    }

    @Override
    public CloseableHttpResponse getDocumentStatus(long senderId, String uuid) {
        return this.getDocumentStatus(String.format("/documents/%s/%s/status", senderId, uuid));
    }

    private CloseableHttpResponse getDocumentStatus(String path) {
        HttpGet httpGet = new HttpGet(this.digipostUrl.resolve(path));
        httpGet.setHeader("Accept", "application/vnd.digipost-v7+xml");
        return this.send((HttpRequestBase)httpGet);
    }

    @Override
    public CloseableHttpResponse getContent(String path) {
        HttpGet httpGet = new HttpGet(this.digipostUrl.resolve(path));
        return this.send((HttpRequestBase)httpGet);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Recipients search(String searchString) {
        HttpGet httpGet = new HttpGet(this.digipostUrl.resolve(this.createEncodedURIPath(this.getEntryPoint().getSearchUri().getPath() + ENTRY_POINT + searchString)));
        httpGet.setHeader("Accept", "application/vnd.digipost-v7+xml");
        try (CloseableHttpResponse response = this.send((HttpRequestBase)httpGet);){
            Recipients recipients = JAXBContextUtils.unmarshal(JAXBContextUtils.recipientsContext, response.getEntity().getContent(), Recipients.class);
            return recipients;
        }
        catch (IOException e) {
            throw new DigipostClientException(ErrorCode.GENERAL_ERROR, "Error while unmarshalling response: " + ExceptionUtils.exceptionNameAndMessage(e), e);
        }
    }

    private URI createEncodedURIPath(String path) {
        try {
            return new URI(null, null, path, null);
        }
        catch (URISyntaxException e) {
            throw new DigipostClientException(ErrorCode.GENERAL_ERROR, "Error encoding search path because of " + ExceptionUtils.exceptionNameAndMessage(e), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Autocomplete searchSuggest(String searchString) {
        HttpGet httpGet = new HttpGet(this.digipostUrl.resolve(this.createEncodedURIPath(this.getEntryPoint().getAutocompleteUri().getPath() + ENTRY_POINT + searchString)));
        httpGet.setHeader("Accept", "application/vnd.digipost-v7+xml");
        try (CloseableHttpResponse response = this.send((HttpRequestBase)httpGet);){
            Autocomplete autocomplete = JAXBContextUtils.unmarshal(JAXBContextUtils.autocompleteContext, response.getEntity().getContent(), Autocomplete.class);
            return autocomplete;
        }
        catch (IOException e) {
            throw new DigipostClientException(ErrorCode.GENERAL_ERROR, "Error while unmarshalling response: " + ExceptionUtils.exceptionNameAndMessage(e), e);
        }
    }

    @Override
    public void addFilter(HttpResponseInterceptor interceptor) {
        this.httpClientBuilder.addInterceptorLast(interceptor);
    }

    @Override
    public void addFilter(HttpRequestInterceptor interceptor) {
        this.httpClientBuilder.addInterceptorLast(interceptor);
    }

    @Override
    public void buildApacheHttpClientBuilder() {
        this.httpClient = this.httpClientBuilder.build();
    }

    @Override
    public CloseableHttpResponse identifyRecipient(Identification identification) {
        HttpPost httpPost = new HttpPost(this.digipostUrl.resolve(this.getEntryPoint().getIdentificationUri().getPath()));
        httpPost.setHeader("Accept", "application/vnd.digipost-v7+xml");
        httpPost.setHeader("Content-Type", "application/vnd.digipost-v7+xml");
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        JAXBContextUtils.marshal(JAXBContextUtils.identificationContext, identification, (OutputStream)bao);
        httpPost.setEntity((HttpEntity)new ByteArrayEntity(bao.toByteArray()));
        return this.send((HttpRequestBase)httpPost);
    }

    private EntryPoint fetchEntryPoint() throws IOException {
        HttpGet httpGet = new HttpGet(this.digipostUrl.resolve(ENTRY_POINT));
        httpGet.setHeader("Accept", "application/vnd.digipost-v7+xml");
        HttpCoreContext httpCoreContext = HttpCoreContext.create();
        httpCoreContext.setAttribute("NOT_SIGNED_RESPONSE", (Object)true);
        Throwable throwable = null;
        try (CloseableHttpResponse execute = this.send((HttpRequestBase)httpGet, (HttpContext)httpCoreContext);){
            if (execute.getStatusLine().getStatusCode() == 200) {
                EntryPoint entryPoint = JAXBContextUtils.unmarshal(JAXBContextUtils.entryPointContext, execute.getEntity().getContent(), EntryPoint.class);
                return entryPoint;
            }
            try {
                ErrorMessage errorMessage = JAXBContextUtils.unmarshal(JAXBContextUtils.errorMessageContext, execute.getEntity().getContent(), ErrorMessage.class);
                throw new DigipostClientException(errorMessage);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private CloseableHttpResponse send(HttpRequestBase request) {
        return this.send(request, null);
    }

    private CloseableHttpResponse send(HttpRequestBase request, HttpContext context) {
        try {
            if (this.config != null) {
                request.setConfig(this.config);
            }
            request.setHeader("X-Digipost-UserId", this.brokerId + "");
            if (context == null) {
                return this.httpClient.execute((HttpUriRequest)request);
            }
            return this.httpClient.execute((HttpUriRequest)request, context);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public SenderInformation getSenderInformation(long senderId) {
        return (SenderInformation)this.cached.senderInformation.get((Object)String.valueOf(senderId), () -> this.getResource(this.getEntryPoint().getSenderInformationUri().getPath() + ENTRY_POINT + senderId, SenderInformation.class));
    }

    @Override
    public SenderInformation getSenderInformation(String orgnr, String avsenderenhet) {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("org_id", orgnr);
        if (avsenderenhet != null) {
            queryParams.put("part_id", avsenderenhet);
        }
        return (SenderInformation)this.cached.senderInformation.get((Object)(orgnr + Optional.ofNullable(avsenderenhet).map(enhet -> "-" + enhet).orElse("")), () -> this.getResource(this.getEntryPoint().getSenderInformationUri().getPath(), queryParams, SenderInformation.class));
    }

    @Override
    public SenderInformation getSenderInformation(MayHaveSender mayHaveSender) {
        AuthorialSender authorialSender = AuthorialSender.resolve(this.brokerId, mayHaveSender);
        if (authorialSender.is(AuthorialSender.Type.ACCOUNT_ID)) {
            return this.getSenderInformation(authorialSender.getAccountId());
        }
        return this.getSenderInformation(authorialSender.getOrganization().organizationId, authorialSender.getOrganization().partId);
    }

    private <R> R getResource(String path, Class<R> entityType) {
        return this.getResource(path, new HashMap(), entityType);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <R, P> R getResource(String path, Map<String, P> queryParams, Class<R> entityType) {
        try {
            HttpGet httpGet = new HttpGet(this.digipostUrl.resolve(path));
            URIBuilder uriBuilder = new URIBuilder(httpGet.getURI());
            for (Map.Entry<String, P> param : queryParams.entrySet()) {
                uriBuilder.setParameter(param.getKey(), param.getValue().toString());
            }
            httpGet.setURI(uriBuilder.build());
            httpGet.setHeader("Accept", "application/vnd.digipost-v7+xml");
            try (CloseableHttpResponse execute = this.send((HttpRequestBase)httpGet);){
                Communicator.checkResponse(execute, this.eventLogger);
                Object object = JAXB.unmarshal((InputStream)execute.getEntity().getContent(), entityType);
                return (R)object;
            }
            catch (IOException e) {
                throw new DigipostClientException(ErrorCode.GENERAL_ERROR, e.getMessage());
            }
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public Inbox getInbox(SenderId senderId, int offset, int limit) {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("offset", String.valueOf(offset));
        queryParams.put("limit", String.valueOf(limit));
        return this.getResource(String.format("/%s/inbox", senderId.getId()), queryParams, Inbox.class);
    }

    @Override
    public InputStream getInboxDocumentContentStream(InboxDocument inboxDocument) {
        HttpGet httpGet = new HttpGet(inboxDocument.getContentUri());
        httpGet.setHeader("Accept", ContentType.WILDCARD.toString());
        HttpCoreContext httpCoreContext = HttpCoreContext.create();
        httpCoreContext.setAttribute("NOT_SIGNED_RESPONSE", (Object)true);
        return HttpClientUtils.safelyOfferEntityStreamExternally(this.send((HttpRequestBase)httpGet, (HttpContext)httpCoreContext), this.eventLogger);
    }

    @Override
    public void deleteInboxDocument(InboxDocument inboxDocument) {
        this.send((HttpRequestBase)new HttpDelete(inboxDocument.getDeleteUri()));
    }
}

