/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.filters.request;

import java.io.IOException;
import java.time.Clock;
import java.time.ZonedDateTime;
import no.digipost.api.client.DigipostClient;
import no.digipost.api.client.EventLogger;
import no.digipost.api.client.util.DateUtils;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestDateInterceptor
implements HttpRequestInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(RequestDateInterceptor.class);
    private final EventLogger eventLogger;
    private final Clock clock;

    public RequestDateInterceptor(EventLogger eventListener) {
        this(eventListener, Clock.systemDefaultZone());
    }

    public RequestDateInterceptor(EventLogger eventListener, Clock clock) {
        this.eventLogger = eventListener != null ? eventListener : DigipostClient.NOOP_EVENT_LOGGER;
        this.clock = clock;
    }

    public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
        this.modifyRequest(httpRequest);
    }

    private void log(String stringToSignMsg) {
        LOG.debug(stringToSignMsg);
        this.eventLogger.log(stringToSignMsg);
    }

    private void modifyRequest(HttpRequest httpRequest) {
        String dateOnRFC1123Format = DateUtils.formatDate(ZonedDateTime.now(this.clock));
        httpRequest.setHeader("Date", dateOnRFC1123Format);
        this.log(this.getClass().getSimpleName() + " satt headeren " + "Date" + "=" + dateOnRFC1123Format);
    }
}

