/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.representations;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import no.digipost.api.client.representations.AuthenticationLevel;
import no.digipost.api.client.representations.ContentHash;
import no.digipost.api.client.representations.DataTypeHolder;
import no.digipost.api.client.representations.EmailNotification;
import no.digipost.api.client.representations.EncryptionInfo;
import no.digipost.api.client.representations.FileType;
import no.digipost.api.client.representations.Invoice;
import no.digipost.api.client.representations.Link;
import no.digipost.api.client.representations.Relation;
import no.digipost.api.client.representations.Representation;
import no.digipost.api.client.representations.SensitivityLevel;
import no.digipost.api.client.representations.SmsNotification;
import no.digipost.api.datatypes.DataType;
import org.apache.commons.lang3.StringUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="document", propOrder={"uuid", "subject", "digipostFileType", "opened", "openingReceipt", "smsNotification", "emailNotification", "authenticationLevel", "sensitivityLevel", "encrypted", "contentHash", "links", "dataType"})
@XmlSeeAlso(value={Invoice.class})
public class Document
extends Representation {
    private static final Pattern UUID_PATTERN = Pattern.compile("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}");
    @XmlElement(name="uuid", required=true)
    public final String uuid;
    @XmlElement(name="subject", required=true)
    public final String subject;
    @XmlElement(name="file-type", required=true)
    protected String digipostFileType;
    @XmlElement(nillable=false)
    protected Boolean opened;
    @XmlElement(name="opening-receipt")
    public final String openingReceipt;
    @XmlElement(name="sms-notification")
    public final SmsNotification smsNotification;
    @XmlElement(name="email-notification")
    public final EmailNotification emailNotification;
    @XmlElement(name="authentication-level")
    public final AuthenticationLevel authenticationLevel;
    @XmlElement(name="sensitivity-level")
    public final SensitivityLevel sensitivityLevel;
    @XmlElement(name="encrypted")
    protected EncryptionInfo encrypted;
    @XmlElement(name="content-hash", nillable=false)
    protected ContentHash contentHash;
    @XmlElement(name="data-type")
    protected DataTypeHolder dataType;
    @XmlAttribute(name="technical-type")
    private String technicalType;

    @XmlElement(name="link")
    protected List<Link> getLinks() {
        return this.links;
    }

    public Document() {
        this((String)null, (String)null, (FileType)null);
    }

    public Document(String uuid, String subject, FileType fileType) {
        this(uuid, subject, fileType, null, null, null, null, null, null, null, (String[])null);
    }

    public Document(String uuid, String subject, FileType fileType, DataType dataType) {
        this(uuid, subject, fileType, null, null, null, null, null, null, dataType, (String[])null);
    }

    public Document(String uuid, String subject, FileType fileType, String openingReceipt, SmsNotification smsNotification, EmailNotification emailNotification, AuthenticationLevel authenticationLevel, SensitivityLevel sensitivityLevel) {
        this(uuid, subject, fileType, openingReceipt, smsNotification, emailNotification, authenticationLevel, sensitivityLevel, null, null, (String[])null);
    }

    public Document(String uuid, String subject, FileType fileType, String openingReceipt, SmsNotification smsNotification, EmailNotification emailNotification, AuthenticationLevel authenticationLevel, SensitivityLevel sensitivityLevel, Boolean opened, DataType dataType, String ... technicalType) {
        this.uuid = StringUtils.lowerCase((String)uuid);
        this.subject = subject;
        this.digipostFileType = Objects.toString(fileType, null);
        this.openingReceipt = (String)StringUtils.defaultIfBlank((CharSequence)openingReceipt, null);
        this.opened = opened == Boolean.TRUE ? Boolean.valueOf(true) : null;
        this.smsNotification = smsNotification;
        this.emailNotification = emailNotification;
        this.authenticationLevel = authenticationLevel;
        this.sensitivityLevel = sensitivityLevel;
        this.technicalType = Document.parseTechnicalTypes(technicalType);
        this.dataType = dataType != null ? new DataTypeHolder(dataType) : null;
        this.validate();
    }

    static String parseTechnicalTypes(String ... technicalTypes) {
        if (technicalTypes == null || technicalTypes.length == 0) {
            return null;
        }
        return Stream.of(technicalTypes).filter(s -> Objects.nonNull(s) && !s.isEmpty()).map(String::trim).collect(Collectors.collectingAndThen(Collectors.joining(","), joined -> joined.isEmpty() ? null : joined));
    }

    public Document copyDocumentAndSetDigipostFileTypeToPdf() {
        Document newDoc = new Document(this.uuid, this.subject, new FileType("pdf"), this.openingReceipt, this.smsNotification, this.emailNotification, this.authenticationLevel, this.sensitivityLevel, this.opened, this.dataType != null ? this.dataType.get() : null, this.getTechnicalType());
        newDoc.encrypted = this.encrypted == null ? null : this.encrypted.copy();
        newDoc.setContentHash(this.contentHash);
        return newDoc;
    }

    private void validate() {
        ArrayList<String> errors = new ArrayList<String>();
        if (this.uuid != null && !UUID_PATTERN.matcher(this.uuid).matches()) {
            errors.add("Not a UUID: " + this.uuid);
        }
        if (this.openingReceipt != null && this.opened != null) {
            errors.add("Both openingReceipt and opened was set");
        }
        if (!errors.isEmpty()) {
            throw new IllegalStateException(errors.size() + " errors when instantiating " + Document.class.getSimpleName() + "\n - " + StringUtils.join(errors, (String)"\n - "));
        }
    }

    public static Document technicalAttachment(FileType fileType, String ... type) {
        Document document = new Document(UUID.randomUUID().toString(), null, fileType);
        document.technicalType = Document.parseTechnicalTypes(type);
        return document;
    }

    public void setContentHash(ContentHash contentHash) {
        this.contentHash = contentHash;
    }

    public void setDigipostFileType(FileType fileType) {
        this.digipostFileType = fileType.toString();
    }

    public String getDigipostFileType() {
        return this.digipostFileType;
    }

    public boolean is(FileType fileType) {
        return fileType.equals(new FileType(this.digipostFileType));
    }

    public Document encrypt() {
        if (this.encrypted != null) {
            throw new IllegalStateException("Document already set to encrypted, are you calling encrypt() twice?");
        }
        this.encrypted = new EncryptionInfo();
        return this;
    }

    public boolean willBeEncrypted() {
        return this.encrypted != null;
    }

    public EncryptionInfo getEncrypted() {
        return this.encrypted;
    }

    public Link getAddContentLink() {
        return this.getLinkByRelationName(Relation.ADD_CONTENT);
    }

    public Link getEncryptionKeyLink() {
        return this.getLinkByRelationName(Relation.GET_ENCRYPTION_KEY);
    }

    public String[] getTechnicalType() {
        return this.technicalType != null ? this.technicalType.split(",") : null;
    }

    public boolean isOpened() {
        return this.opened != null && this.opened != false;
    }

    public Optional<DataType> getDataType() {
        return Optional.ofNullable(this.dataType).map(DataTypeHolder::get);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " with uuid '" + this.uuid + "'" + Optional.ofNullable(this.technicalType).map(t -> ", technicalType '" + t + "'").orElse("") + (this.willBeEncrypted() ? Optional.ofNullable(this.subject).map(s -> ", subject '" + s + "'").orElse(", no subject") : ", encrypted");
    }

    public void setNumberOfEncryptedPages(int pages) {
        if (this.encrypted == null) {
            throw new IllegalStateException("Tried setting number of encrypted pages, but document is not set to be encrypted. Have you called Document.encrypt()?");
        }
        this.encrypted.setNumberOfPages(pages);
    }
}

