/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.representations;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import no.digipost.api.client.representations.Channel;
import no.digipost.api.client.representations.DeliveryStatus;
import no.digipost.api.client.representations.HashAlgorithm;
import no.digipost.api.client.representations.Link;
import no.digipost.api.client.representations.Read;
import no.digipost.api.client.representations.xml.DateTimeXmlAdapter;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="document-status", propOrder={"attachments", "links"})
@XmlRootElement(name="document-status")
public class DocumentStatus {
    @XmlAttribute(name="uuid")
    public String uuid;
    @XmlAttribute(name="status")
    public DeliveryStatus status;
    @XmlAttribute(name="created")
    @XmlJavaTypeAdapter(value=DateTimeXmlAdapter.class)
    @XmlSchemaType(name="dateTime")
    public ZonedDateTime created;
    @XmlAttribute(name="delivered", required=false)
    @XmlJavaTypeAdapter(value=DateTimeXmlAdapter.class)
    @XmlSchemaType(name="dateTime")
    public ZonedDateTime delivered;
    @XmlAttribute(name="read")
    public Read read;
    @XmlAttribute(name="channel")
    public Channel channel;
    @XmlAttribute(name="is-primary-document")
    public boolean isPrimaryDocument;
    @XmlAttribute(name="content-hash")
    public String contentHash;
    @XmlAttribute(name="content-hash-algorithm")
    public HashAlgorithm contentHashAlgorithm;
    @XmlElement(name="attachments")
    private List<DocumentStatus> attachments = new ArrayList<DocumentStatus>();
    @XmlElement(name="link")
    public List<Link> links = new ArrayList<Link>();

    public DocumentStatus() {
        this(null, null, null, null, null, null, true, null, null, null, null);
    }

    public DocumentStatus(String uuid, DeliveryStatus status, ZonedDateTime created, ZonedDateTime delivered, Read read, Channel channel, boolean isPrimaryDocument, String contentHash, HashAlgorithm contentHashAlgorithm, List<DocumentStatus> attachments, List<Link> links) {
        this.uuid = uuid;
        this.status = status;
        this.created = created;
        this.delivered = delivered;
        this.read = read;
        this.channel = channel;
        this.isPrimaryDocument = isPrimaryDocument;
        this.contentHash = contentHash;
        this.contentHashAlgorithm = contentHashAlgorithm;
        this.attachments = attachments;
        this.links = links;
    }

    public List<DocumentStatus> getAttachments() {
        return Collections.unmodifiableList(this.attachments == null ? new ArrayList() : this.attachments);
    }
}

