/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.representations;

import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import no.digipost.api.client.representations.Channel;
import no.digipost.api.client.representations.Document;
import no.digipost.api.client.representations.Link;
import no.digipost.api.client.representations.MayHaveSender;
import no.digipost.api.client.representations.Message;
import no.digipost.api.client.representations.MessageStatus;
import no.digipost.api.client.representations.Relation;
import no.digipost.api.client.representations.Representation;
import no.digipost.api.client.representations.SenderOrganization;
import no.digipost.api.client.representations.xml.DateTimeXmlAdapter;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="message-delivery", propOrder={"messageId", "deliveryMethod", "senderId", "status", "deliveryTime", "primaryDocument", "attachments", "links"})
@XmlRootElement(name="message-delivery")
public class MessageDelivery
extends Representation
implements MayHaveSender {
    @XmlElement(name="message-id")
    protected String messageId;
    @XmlElement(name="delivery-method", required=true)
    protected Channel deliveryMethod;
    @XmlElement(name="sender-id", nillable=false)
    protected long senderId;
    @XmlElement(required=true)
    protected MessageStatus status;
    @XmlElement(name="delivery-time", type=String.class, nillable=false)
    @XmlJavaTypeAdapter(value=DateTimeXmlAdapter.class)
    @XmlSchemaType(name="dateTime")
    protected ZonedDateTime deliveryTime;
    @XmlElement(name="primary-document", required=true)
    protected Document primaryDocument;
    @XmlElement(name="attachment")
    protected List<Document> attachments;

    public MessageDelivery() {
    }

    public MessageDelivery(String messageId, Channel channel, MessageStatus status, ZonedDateTime deliveryTime) {
        this.messageId = messageId;
        this.deliveryMethod = channel;
        this.status = status;
        this.deliveryTime = deliveryTime;
    }

    @XmlElement(name="link")
    protected List<Link> getLinks() {
        return this.links;
    }

    protected void setLinks(List<Link> links) {
        this.links = links;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public List<Document> getAttachments() {
        return this.attachments != null ? Collections.unmodifiableList(this.attachments) : Collections.emptyList();
    }

    public boolean isSameMessageAs(Message message) {
        return this.messageId.equals(message.messageId);
    }

    public MessageStatus getStatus() {
        return this.status;
    }

    public Link getEncryptionKeyLink() {
        return this.getLinkByRelationName(Relation.GET_ENCRYPTION_KEY);
    }

    public Link getSendLink() {
        return this.getLinkByRelationName(Relation.SEND);
    }

    public boolean willBeDeliveredInDigipost() {
        return Channel.DIGIPOST.equals((Object)this.deliveryMethod);
    }

    public boolean isAlreadyDeliveredToDigipost() {
        return Channel.DIGIPOST.equals((Object)this.deliveryMethod) && this.deliveryTime != null;
    }

    public Link getSelfLink() {
        return this.getLinkByRelationName(Relation.SELF);
    }

    public Channel getChannel() {
        return this.deliveryMethod;
    }

    public ZonedDateTime getDeliveryTime() {
        return this.deliveryTime;
    }

    public Document getPrimaryDocument() {
        return this.primaryDocument;
    }

    public Stream<Document> getAllDocuments() {
        return Stream.concat(Optional.ofNullable(this.primaryDocument).map(Stream::of).orElseGet(Stream::empty), this.getAttachments().stream());
    }

    public Document getDocumentByUuid(String uuid) {
        return this.getAllDocuments().filter(doc -> Objects.equals(uuid, doc.uuid)).findFirst().orElseThrow(() -> new IllegalArgumentException("Document with UUID '" + uuid + "' was not found in this " + this.getClass().getSimpleName() + "."));
    }

    @Override
    public Long getSenderId() {
        return this.senderId;
    }

    @Override
    public SenderOrganization getSenderOrganization() {
        return null;
    }
}

