/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.security;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.SortedMap;
import java.util.TreeMap;
import no.digipost.api.client.security.RequestToSign;
import org.apache.http.Header;
import org.apache.http.HttpRequest;

public class ClientRequestToSign
implements RequestToSign {
    private final HttpRequest clientRequest;

    public ClientRequestToSign(HttpRequest httpRequest) {
        this.clientRequest = httpRequest;
    }

    @Override
    public String getMethod() {
        return this.clientRequest.getRequestLine().getMethod();
    }

    @Override
    public SortedMap<String, String> getHeaders() {
        Header[] headers;
        TreeMap<String, String> sortedHeaders = new TreeMap<String, String>();
        for (Header header : headers = this.clientRequest.getAllHeaders()) {
            sortedHeaders.put(header.getName(), header.getValue());
        }
        return sortedHeaders;
    }

    @Override
    public String getPath() {
        try {
            String path = new URI(this.clientRequest.getRequestLine().getUri()).getRawPath();
            return path != null ? path : "";
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public String getParameters() {
        return ClientRequestToSign.queryParametersFromURI(this.clientRequest.getRequestLine().getUri());
    }

    static String queryParametersFromURI(String uri) {
        int index = uri.indexOf(63);
        return index == -1 ? "" : uri.substring(index + 1);
    }
}

