/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import no.digipost.api.client.errorhandling.DigipostClientException;
import no.digipost.api.client.errorhandling.ErrorCode;
import no.digipost.api.client.util.DigipostPublicKey;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.bouncycastle.cms.CMSAlgorithm;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;

public final class Encrypter {
    public static final Encrypter FAIL_IF_TRYING_TO_ENCRYPT = new Encrypter(null);
    private final DigipostPublicKey key;
    private final JceCMSContentEncryptorBuilder encryptorBuilder;

    public static Encrypter using(DigipostPublicKey digipostPublicKey) {
        return new Encrypter(digipostPublicKey);
    }

    private Encrypter(DigipostPublicKey key) {
        this.key = key;
        this.encryptorBuilder = new JceCMSContentEncryptorBuilder(CMSAlgorithm.AES256_CBC).setProvider("BC");
    }

    public InputStream encrypt(InputStream content) {
        byte[] bytes;
        try {
            bytes = IOUtils.toByteArray((InputStream)content);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getClass().getSimpleName() + ": '" + e.getMessage() + "'", e);
        }
        return this.encrypt(bytes);
    }

    public InputStream encrypt(byte[] content) {
        if (this.key == null) {
            throw new DigipostClientException(ErrorCode.ENCRYPTION_KEY_NOT_FOUND, "Trying to preencrypt but have no encryption key.");
        }
        try {
            CMSEnvelopedDataGenerator gen = new CMSEnvelopedDataGenerator();
            gen.addRecipientInfoGenerator((RecipientInfoGenerator)new JceKeyTransRecipientInfoGenerator(this.key.publicKeyHash.getBytes(), this.key.publicKey));
            CMSEnvelopedData d = gen.generate((CMSTypedData)new CMSProcessableByteArray(content), this.encryptorBuilder.build());
            return new ByteArrayInputStream(d.getEncoded());
        }
        catch (Exception e) {
            if (e instanceof CMSException && ExceptionUtils.getRootCause((Throwable)e) instanceof InvalidKeyException) {
                throw new DigipostClientException(ErrorCode.FAILED_PREENCRYPTION, "Ugyldig krypteringsn\u00f8kkel. (" + InvalidKeyException.class.getName() + ") Er Java Cryptographic Extensions (JCE) Unlimited Strength Jurisdiction Policy Files installert? Dette kan lastes ned fra http://www.oracle.com/technetwork/java/javase/downloads/ under \"Additional Resources\". Plasser filene US_export_policy.jar og local_policy.jar i ${JAVA_HOME}/jre/lib/security (overskriv eksisterende).", e);
            }
            throw new DigipostClientException(ErrorCode.FAILED_PREENCRYPTION, "Feil ved kryptering av innhold: " + e.getClass().getSimpleName() + " '" + e.getMessage() + "'", e);
        }
    }
}

