/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.util;

import java.io.IOException;
import java.io.InputStream;
import no.digipost.api.client.Communicator;
import no.digipost.api.client.EventLogger;
import no.digipost.api.client.errorhandling.DigipostClientException;
import no.digipost.api.client.errorhandling.ErrorCode;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.util.EntityUtils;

public final class HttpClientUtils {
    public static InputStream safelyOfferEntityStreamExternally(CloseableHttpResponse response, EventLogger eventLogger) {
        HttpEntity entity = null;
        try {
            Communicator.checkResponse(response, eventLogger);
            entity = response.getEntity();
            return entity.getContent();
        }
        catch (IOException | RuntimeException e) {
            try (CloseableHttpResponse autoClosed = response;){
                EntityUtils.consume((HttpEntity)entity);
            }
            catch (IOException | RuntimeException entityConsumptionException) {
                e.addSuppressed(entityConsumptionException);
            }
            throw e instanceof DigipostClientException ? (DigipostClientException)e : new DigipostClientException(ErrorCode.GENERAL_ERROR, e.getMessage(), e);
        }
    }

    private HttpClientUtils() {
    }
}

