/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.internal.delivery;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import no.digipost.api.client.errorhandling.DigipostClientException;
import no.digipost.api.client.errorhandling.ErrorCode;
import no.digipost.api.client.representations.Channel;
import no.digipost.api.client.representations.Document;
import no.digipost.api.client.representations.FileType;
import no.digipost.api.client.representations.Message;
import no.digipost.api.client.security.Encrypter;
import no.digipost.print.validate.PdfValidationResult;
import no.digipost.print.validate.PdfValidationSettings;
import no.digipost.print.validate.PdfValidator;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DocumentsPreparer {
    private static final Logger LOG = LoggerFactory.getLogger(DocumentsPreparer.class);
    private final PdfValidator pdfValidator;

    DocumentsPreparer(PdfValidator pdfValidator) {
        this.pdfValidator = pdfValidator;
    }

    Map<Document, InputStream> prepare(Map<Document, InputStream> documentsAndContent, Message message, Encrypter encrypter, Supplier<PdfValidationSettings> pdfValidationSettings) throws IOException {
        LinkedHashMap<Document, InputStream> prepared = new LinkedHashMap<Document, InputStream>();
        if (message.recipient.hasPrintDetails() && message.recipient.hasDigipostIdentification()) {
            throw new IllegalStateException("Forventet message med enkelt kanal");
        }
        for (Document document : documentsAndContent.keySet().stream().sorted(message.documentOrder())::iterator) {
            if (document.willBeEncrypted()) {
                byte[] byteContent = IOUtils.toByteArray((InputStream)documentsAndContent.get(document));
                LOG.debug("Validerer dokument med uuid '{}' f\u00f8r kryptering", (Object)document.uuid);
                this.validateAndSetNrOfPages(message.getChannel(), document, byteContent, pdfValidationSettings);
                LOG.debug("Krypterer innhold for dokument med uuid '{}'", (Object)document.uuid);
                prepared.put(document, encrypter.encrypt(byteContent));
                continue;
            }
            prepared.put(document, documentsAndContent.get(document));
        }
        return prepared;
    }

    Optional<PdfInfo> validateAndSetNrOfPages(Channel channel, Document document, byte[] content, Supplier<PdfValidationSettings> pdfValidationSettings) {
        Optional<PdfInfo> pdfInfo;
        PdfValidationResult pdfValidation;
        if (channel == Channel.PRINT && !document.is(FileType.PDF)) {
            throw new DigipostClientException(ErrorCode.INVALID_PDF_CONTENT, "PDF is required for direct-to-print messages. Document with uuid " + document.uuid + " had filetype " + document.getDigipostFileType());
        }
        if (document.is(FileType.PDF)) {
            LOG.debug("Validerer PDF-dokument med uuid '{}'", (Object)document.uuid);
            pdfValidation = this.pdfValidator.validate(content, pdfValidationSettings.get());
            if (document.willBeEncrypted()) {
                document.setNumberOfEncryptedPages(pdfValidation.pages);
            }
            pdfInfo = Optional.of(new PdfInfo(pdfValidation.pages));
        } else {
            pdfValidation = PdfValidationResult.EVERYTHING_OK;
            pdfInfo = Optional.empty();
        }
        if (channel == Channel.PRINT && !pdfValidation.okForPrint || !pdfValidation.okForWeb) {
            throw new DigipostClientException(ErrorCode.INVALID_PDF_CONTENT, pdfValidation.toString());
        }
        return pdfInfo;
    }

    static class PdfInfo {
        final int pages;
        final boolean hasOddNumberOfPages;

        public PdfInfo(int numberOfPages) {
            this.pages = numberOfPages;
            this.hasOddNumberOfPages = this.pages % 2 == 1;
        }
    }
}

