/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.representations;

import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import no.digipost.api.client.representations.PrintInstruction;
import no.digipost.api.client.representations.PrintInstructions;
import no.digipost.api.client.representations.PrintRecipient;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="print-details", propOrder={"recipient", "returnAddress", "postType", "printColors", "nondeliverableHandling", "printInstructions"})
public class PrintDetails {
    @XmlElement(required=true)
    protected PrintRecipient recipient;
    @XmlElement(name="return-address", required=true)
    protected PrintRecipient returnAddress;
    @XmlElement(name="color")
    protected PrintColors printColors;
    @XmlElement(name="nondeliverable-handling")
    protected NondeliverableHandling nondeliverableHandling;
    @XmlElement(name="print-instructions")
    protected PrintInstructions printInstructions;
    @XmlElement(name="post-type", required=true)
    private final String postType = "A";

    PrintDetails() {
    }

    public PrintDetails(PrintRecipient recipient, PrintRecipient returnAddress) {
        this(recipient, returnAddress, null, null);
    }

    public PrintDetails(PrintRecipient recipient, PrintRecipient returnAddress, PrintColors colors, NondeliverableHandling nondeliverableHandling) {
        this.recipient = recipient;
        this.returnAddress = returnAddress;
        this.printColors = colors;
        this.nondeliverableHandling = nondeliverableHandling;
    }

    public void setInstruction(List<PrintInstruction> instructions) {
        if (!instructions.isEmpty()) {
            this.printInstructions = new PrintInstructions(instructions);
        }
    }

    public PrintRecipient getRecipient() {
        return this.recipient;
    }

    public PrintRecipient getReturnAddress() {
        return this.returnAddress;
    }

    public PrintColors getPrintColors() {
        return this.printColors;
    }

    public NondeliverableHandling getNondeliverableHandling() {
        return this.nondeliverableHandling;
    }

    public static enum PrintColors {
        MONOCHROME,
        COLORS;

    }

    public static enum NondeliverableHandling {
        RETURN_TO_SENDER,
        SHRED;

    }
}

