/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.testing;

import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.BlockingHandler;
import io.undertow.server.handlers.form.FormData;
import io.undertow.server.handlers.form.FormParserFactory;
import io.undertow.server.handlers.form.MultiPartParserDefinition;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.net.ConnectException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.time.Clock;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import no.digipost.api.client.SenderId;
import no.digipost.api.client.errorhandling.ErrorCode;
import no.digipost.api.client.representations.Channel;
import no.digipost.api.client.representations.DigipostUri;
import no.digipost.api.client.representations.EncryptionCertificate;
import no.digipost.api.client.representations.EntryPoint;
import no.digipost.api.client.representations.ErrorMessage;
import no.digipost.api.client.representations.ErrorType;
import no.digipost.api.client.representations.IdentificationResult;
import no.digipost.api.client.representations.Link;
import no.digipost.api.client.representations.Message;
import no.digipost.api.client.representations.MessageDelivery;
import no.digipost.api.client.representations.MessageStatus;
import no.digipost.api.client.representations.Relation;
import no.digipost.api.client.representations.sender.SenderFeature;
import no.digipost.api.client.representations.sender.SenderFeatureName;
import no.digipost.api.client.representations.sender.SenderInformation;
import no.digipost.api.client.representations.sender.SenderStatus;
import no.digipost.api.client.testing.MockfriendlyResponse;
import no.digipost.api.client.util.DateUtils;
import no.digipost.api.client.util.JAXBContextUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.entity.ByteArrayEntity;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DigipostApiMock
implements HttpHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DigipostApiMock.class);
    private static final String certificate = "-----BEGIN CERTIFICATE-----\nMIIDczCCAlugAwIBAgIEfMS/vzANBgkqhkiG9w0BAQsFADBqMQswCQYDVQQGEwJO\nTzENMAsGA1UECBMET3NsbzENMAsGA1UEBxMET3NsbzERMA8GA1UEChMIRGlnaXBv\nc3QxEDAOBgNVBAsTB0RpZ2lwb3MxGDAWBgNVBAMTD1NpbW9uIEFuZGVyc3NvbjAe\nFw0xNjA2MTMxMDE5MTJaFw0xNjA5MTExMDE5MTJaMGoxCzAJBgNVBAYTAk5PMQ0w\nCwYDVQQIEwRPc2xvMQ0wCwYDVQQHEwRPc2xvMREwDwYDVQQKEwhEaWdpcG9zdDEQ\nMA4GA1UECxMHRGlnaXBvczEYMBYGA1UEAxMPU2ltb24gQW5kZXJzc29uMIIBIjAN\nBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAgTSx+3/K/AOpG1TGcnceq6H1FNp1\nVseUULBFhT7wmodEhijI5RPOkG0Okt0GA6yT6BNS7xhPrxLROSnFPCURtq/h13Gf\nO/5DKUqoofIzP2f26s96GNwlUHLTnnGQ1mq2LTVu8Hi3vXwXjeBWoHSVceF8nPZr\nYWm4Cxqn09dxWv/FuOqX1JwLwWBGgkyONohdmFaHFg+MRHzArvkdBM8sleD8Cwyx\nASlB7+9ttVZrssg2IxZ6wBEbkulGjLOrOa//dxwlFpEww9pm89hRIdj9sRUScbCO\nHto7KUMbbhZgiaDvCjIfOVeGWCJKyMF7avPk/86z11F5rjF33JieItn6RwIDAQAB\noyEwHzAdBgNVHQ4EFgQU/bPHm6m6ISWYU0DOUw8KqjEF8w4wDQYJKoZIhvcNAQEL\nBQADggEBAEj05cTCWZuzhjKyOx2SvLc40WHPkTZCLx+4LNZHdckKgdGMcJJfqYr+\neTbsdzBgmFa1wMO0H6fKcaEgiJj2G9B4no/7bUWY2q3I21ZprJpiJnvuk36blcw1\ns7jaDFQ758fyqAV/Sqqz91gSKPRsKCtcHC72XEqdc40qcecY1+3OVg5rADJHC8u+\nQaXy0670ViiULi3vmQNAtD28DZcOHbbplVXKSyVifnALTrCQBYMqQF8GpKs2NcId\n0XUU7HFKXmYESXGY4sW77+l8mRXLcpD/ofAszblUPpPCFFWozH4/WoY7tDRDhwkz\n6vYEpI930hzj81irYEPyRvoDAaEv2Zc=\n-----END CERTIFICATE-----";
    private static final String PRINT_CERTIFICATE = "-----BEGIN CERTIFICATE-----\nMIIDIjCCAgqgAwIBAgIGAU3b9jC0MA0GCSqGSIb3DQEBBQUAMGExCzAJBgNVBAYT\nAk5PMSIwIAYDVQQKExlQT1NURU4gTk9SR0UgQVMtOTg0NjYxMTg1MREwDwYDVQQL\nEwhESUdJUE9TVDEbMBkGA1UEAxMSRElHSVBPU1QgQVBJIENBIFFBMB4XDTE1MDYx\nMDA1MzQxM1oXDTE4MDYxMDA1MzQxM1owITEfMB0GA1UEAwwWdmlya3NvbWhldGlk\nLTEwNjc4ODgxMTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBALnb99ef\nPvrHseQRkkxR6TbJ/Ckgw2T5w1BuazGr39s+uee5jRWWixgVE7AwyQGaSl8s8RlC\nlsV4mcokkPT4WyUl1KSNl7xQdArlXtd5AR4dlqOPd1r0Gzl5A980m50VBjSE4ojP\nBR78/rSp9cMBbzYwkoDXBcDpfcsAotawA1J9ryzVo9rlD4TYdobO84sqlyX4wiYS\nNAV27TjbkbgxU8Gxv/kHC+TJTgG6Ukul9Df/wdG1MowWr+er1DXAQrGReaukUVYT\nyhqxuYkxnZcV314X7QENynbdajHZyj16Odpve0Blh8upTo3mXc6BVf76sRgbUbbb\nB8ITqWkT1Z7UQ6MCAwEAAaMgMB4wDAYDVR0TAQH/BAIwADAOBgNVHQ8BAf8EBAMC\nBPAwDQYJKoZIhvcNAQEFBQADggEBAEN2q1x+sKWKYL+VAdjBDHy29AgyiGTd1v9y\nHQt8zBTGfLwvy9kRWjW0YOJwdygFcfjLm5yfWvy6tQEHCZz9GQarwMEstpNMlp/o\nbsXwVKKquaN4EkEoKjmw8Fh2tkv9XPkehEN4+kxq+E21yZze5aOSwDWubOmw4J69\nIJDz6gqEtCUVTXpxbY6+fHrrJdRuiwr08WGyCiNdx/nVZyJABQU6DgQP5Kww0VK5\nusI9Gqj7qQEdA0U2VkHzpRZIycqfC2AEscp/vX5okiut4AW4wenSBUu1SGFrUpyL\nXs4gF0Z5jaX379JNt5ra+w8uYWc48R2Zs6UryrT6Tjy2v413Zd0=\n-----END CERTIFICATE-----";
    private final Clock clock;
    public final CloseableHttpResponse defaultResponse;
    private int port;
    private Undertow server;
    private Map<Method, RequestsAndResponses> requestsAndResponsesMap;
    private KeyPair keyPair;

    public DigipostApiMock(Clock clock) {
        this.clock = clock;
        this.defaultResponse = DigipostApiMock.getDefaultResponse(clock);
    }

    public void handleRequest(HttpServerExchange httpContext) throws Exception {
        HttpEntity entity;
        CloseableHttpResponse response;
        int httpResponse = 200;
        HttpString method = httpContext.getRequestMethod();
        String requestPath = httpContext.getRequestPath().toLowerCase();
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        if (requestPath.equals("/identification")) {
            httpResponse = this.serviceIdentifyRecipient(httpContext, bao);
        } else if (method.equals(new HttpString("POST"))) {
            httpResponse = this.serviceMultipartrequest(httpContext, bao);
        } else if (requestPath.equals("/printcertificate")) {
            httpResponse = this.servicePrintCertificate(httpContext, bao);
        } else if (requestPath.equals("/getsenderinformation")) {
            this.serviceSenderInformation(httpContext, bao);
        } else if (requestPath.equals("/getdocumentstatus")) {
            response = this.requestsAndResponsesMap.get((Object)Method.GET_DOCUMENT_STATUS).getResponse(httpContext.getRequestPath());
            httpResponse = response.getStatusLine().getStatusCode();
            entity = response.getEntity();
            if (entity != null) {
                entity.writeTo((OutputStream)bao);
            }
        } else if (requestPath.equals("/getdocumentevents")) {
            response = this.requestsAndResponsesMap.get((Object)Method.GET_DOCUMENTS_EVENTS).getResponse(httpContext.getRequestPath());
            httpResponse = response.getStatusLine().getStatusCode();
            entity = response.getEntity();
            if (entity != null) {
                entity.writeTo((OutputStream)bao);
            }
        } else if (requestPath.equals("/")) {
            JAXBContextUtils.marshal(JAXBContextUtils.jaxbContext, new EntryPoint(certificate, new Link(Relation.CREATE_MESSAGE, new DigipostUri("http://localhost:9999/create")), new Link(Relation.GET_PRINT_ENCRYPTION_CERTIFICATE, new DigipostUri("http://localhost:9999/printcertificate")), new Link(Relation.GET_SENDER_INFORMATION, new DigipostUri("http://localhost:9999/getsenderinformation")), new Link(Relation.DOCUMENT_EVENTS, new DigipostUri("http://localhost:9999/getdocumentevents")), new Link(Relation.IDENTIFY_RECIPIENT, new DigipostUri("http://localhost:9999/identification"))), (OutputStream)bao);
        } else {
            response = this.requestsAndResponsesMap.get((Object)Method.GET_CONTENT).getResponse(httpContext.getRequestPath());
            httpResponse = response.getStatusLine().getStatusCode();
            entity = response.getEntity();
            if (entity != null) {
                entity.writeTo((OutputStream)bao);
            }
        }
        byte[] bytes = bao.toByteArray();
        HeaderMap responseHeaders = httpContext.getResponseHeaders();
        String dateOnRFC1123Format = DateUtils.formatDate(ZonedDateTime.now(this.clock));
        String xContentSHA256 = DigipostApiMock.generateXContentSHA256(bytes);
        String signature = httpResponse + "\n" + httpContext.getRequestPath().toLowerCase() + "\ndate: " + dateOnRFC1123Format + "\nx-content-sha256: " + xContentSHA256 + "\n";
        responseHeaders.add(new HttpString("Date"), dateOnRFC1123Format);
        responseHeaders.add(new HttpString("X-Content-SHA256"), xContentSHA256);
        responseHeaders.add(new HttpString("X-Digipost-Signature"), DigipostApiMock.generateXDigipostSignature(this.keyPair, signature));
        httpContext.setStatusCode(httpResponse);
        httpContext.startBlocking();
        IOUtils.copy((InputStream)new ByteArrayInputStream(bytes), (OutputStream)httpContext.getOutputStream());
    }

    private int serviceIdentifyRecipient(HttpServerExchange httpContext, ByteArrayOutputStream bao) throws IOException {
        CloseableHttpResponse response = this.requestsAndResponsesMap.get((Object)Method.IDENTIFY_RECIPIENT).getResponse(httpContext.getRequestPath());
        if (response == null) {
            JAXBContextUtils.marshal(JAXBContextUtils.jaxbContext, IdentificationResult.digipost("test.testsson#1234"), (OutputStream)bao);
            return 200;
        }
        response.getEntity().writeTo((OutputStream)bao);
        return response.getStatusLine().getStatusCode();
    }

    private int serviceSenderInformation(HttpServerExchange httpContext, ByteArrayOutputStream bao) throws IOException {
        CloseableHttpResponse response = this.requestsAndResponsesMap.get((Object)Method.GET_SENDER_INFORMATION).getResponse(httpContext.getRequestPath());
        if (response == null) {
            ArrayList<SenderFeature> senderFeatures = new ArrayList<SenderFeature>();
            senderFeatures.add(SenderFeatureName.DELIVERY_DIRECT_TO_PRINT.withNoParam());
            senderFeatures.add(SenderFeatureName.DIGIPOST_DELIVERY.withNoParam());
            senderFeatures.add(SenderFeatureName.PRINTVALIDATION_FONTS.withNoParam());
            senderFeatures.add(SenderFeatureName.PRINTVALIDATION_PDFVERSION.withNoParam());
            JAXBContextUtils.marshal(JAXBContextUtils.jaxbContext, new SenderInformation(SenderId.of(9999L), SenderStatus.VALID_SENDER, senderFeatures), (OutputStream)bao);
            return 200;
        }
        response.getEntity().writeTo((OutputStream)bao);
        return response.getStatusLine().getStatusCode();
    }

    private int servicePrintCertificate(HttpServerExchange httpContext, ByteArrayOutputStream bao) {
        this.requestsAndResponsesMap.get((Object)Method.GET_PRINT_CERTIFICATE).getResponse(httpContext.getRequestPath());
        JAXBContextUtils.marshal(JAXBContextUtils.jaxbContext, new EncryptionCertificate(PRINT_CERTIFICATE), (OutputStream)bao);
        return 200;
    }

    private int serviceMultipartrequest(HttpServerExchange httpContext, ByteArrayOutputStream bao) throws IOException {
        Message message;
        HeaderMap requestHeaders = httpContext.getRequestHeaders();
        String digipostMultipartContentType = requestHeaders.getFirst(Headers.CONTENT_TYPE);
        String boundary = Headers.extractQuotedValueFromHeader((String)digipostMultipartContentType, (String)"boundary");
        requestHeaders.addFirst(Headers.CONTENT_TYPE, "multipart/form-data; boundary=" + boundary);
        FormData parsedMultipart = FormParserFactory.builder().addParser((FormParserFactory.ParserDefinition)new MultiPartParserDefinition()).build().createParser(httpContext).parseBlocking();
        Map parts = StreamSupport.stream(parsedMultipart.spliterator(), false).flatMap(partName -> parsedMultipart.get(partName).stream()).map(ContentPart::new).collect(Collectors.toMap(ContentPart::getName, Function.identity(), (part1WithDuplicateName, part2WithDuplicateName) -> {
            throw new RuntimeException("Found two parts with same name: " + part1WithDuplicateName + ", " + part2WithDuplicateName);
        }, LinkedHashMap::new));
        String messageString = ((ContentPart)Optional.ofNullable(parts.remove((Object)"message")).orElseThrow((Supplier<NoSuchElementException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$serviceMultipartrequest$2(java.util.Map ), ()Ljava/util/NoSuchElementException;)((Map)parts))).content;
        try (ByteArrayInputStream messageStream = new ByteArrayInputStream(messageString.getBytes());){
            message = JAXBContextUtils.unmarshal(JAXBContextUtils.jaxbContext, messageStream, Message.class);
        }
        RequestsAndResponses requestsAndResponses = this.requestsAndResponsesMap.get((Object)Method.MULTIPART_MESSAGE);
        CloseableHttpResponse response = requestsAndResponses.getResponse(message.primaryDocument.subject);
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            entity.writeTo((OutputStream)bao);
        }
        requestsAndResponses.addRequest(new DigipostRequest(message, new ArrayList<ContentPart>(parts.values())));
        return response.getStatusLine().getStatusCode();
    }

    private static String generateXContentSHA256(byte[] bytes) {
        SHA256Digest digest = new SHA256Digest();
        byte[] entityBytes = bytes;
        digest.update(entityBytes, 0, entityBytes.length);
        byte[] result = new byte[digest.getDigestSize()];
        digest.doFinal(result, 0);
        return new String(Base64.encode((byte[])result));
    }

    private static String generateXDigipostSignature(KeyPair keyPair, String signature) throws InvalidKeyException, NoSuchAlgorithmException, SignatureException {
        Signature instance = Signature.getInstance("SHA256WithRSAEncryption");
        instance.initSign(keyPair.getPrivate());
        instance.update(signature.getBytes());
        byte[] signedSignature = instance.sign();
        return new String(Base64.encode((byte[])signedSignature));
    }

    public DigipostApiMock start(int port, Map<Method, RequestsAndResponses> requestsAndResponsesMap, KeyPair keyPair) {
        this.keyPair = keyPair;
        this.requestsAndResponsesMap = requestsAndResponsesMap;
        this.port = port;
        this.server = Undertow.builder().addHttpListener(port, "localhost", (HttpHandler)new BlockingHandler((HttpHandler)this)).build();
        this.init();
        this.server.start();
        LOG.info("Digipost API client running on port {}", (Object)port);
        return this;
    }

    public void stop() {
        this.server.stop();
        LOG.info("Shutting down Digipost API client mock on port {}", (Object)this.port);
    }

    public void init() {
        this.requestsAndResponsesMap.clear();
        this.requestsAndResponsesMap.put(Method.GET_CONTENT, new RequestsAndResponses());
        this.requestsAndResponsesMap.put(Method.GET_DOCUMENTS_EVENTS, new RequestsAndResponses());
        this.requestsAndResponsesMap.put(Method.GET_DOCUMENT_STATUS, new RequestsAndResponses());
        this.requestsAndResponsesMap.put(Method.GET_PRINT_CERTIFICATE, new RequestsAndResponses());
        this.requestsAndResponsesMap.put(Method.GET_SENDER_INFORMATION, new RequestsAndResponses());
        this.requestsAndResponsesMap.put(Method.SEND_MULTIPART_MESSAGE, new RequestsAndResponses());
        this.requestsAndResponsesMap.put(Method.MULTIPART_MESSAGE, new RequestsAndResponses(new MultipartRequestMatcher()));
        this.requestsAndResponsesMap.put(Method.IDENTIFY_RECIPIENT, new RequestsAndResponses());
    }

    public static CloseableHttpResponse getDefaultResponse(Clock clock) {
        MessageDelivery messageDelivery = new MessageDelivery(UUID.randomUUID().toString(), Channel.DIGIPOST, MessageStatus.COMPLETE, ZonedDateTime.now(clock));
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        JAXBContextUtils.marshal(JAXBContextUtils.jaxbContext, messageDelivery, (OutputStream)bao);
        return MockfriendlyResponse.MockedResponseBuilder.create().status(200).entity((HttpEntity)new ByteArrayEntity(bao.toByteArray())).build();
    }

    private static /* synthetic */ NoSuchElementException lambda$serviceMultipartrequest$2(Map parts) {
        return new NoSuchElementException("Message part of multipart not found in " + parts);
    }

    public static final class ContentPart {
        public final String name;
        public final String mediaType;
        public final String content;

        public ContentPart(FormData.FormValue part) {
            this(Headers.extractQuotedValueFromHeader((String)part.getHeaders().getFirst(Headers.CONTENT_DISPOSITION), (String)"filename"), part.getHeaders().get(Headers.CONTENT_TYPE).getFirst(), part.getValue());
        }

        public ContentPart(String name, String mediaType, String content) {
            this.name = name;
            this.mediaType = mediaType;
            this.content = content;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return "Content '" + this.name + "' (" + this.mediaType + "): " + StringUtils.abbreviate((String)this.content, (int)15);
        }
    }

    public static class DigipostRequest
    extends MockRequest {
        public final Message message;
        public final List<ContentPart> contentParts;

        public DigipostRequest(Message message, List<ContentPart> contentParts) {
            super(message.messageId);
            this.message = message;
            this.contentParts = contentParts;
        }
    }

    public class MultipartRequestMatcher
    implements RequestMatcher {
        public final Map<String, CloseableHttpResponse> responses = new HashMap<String, CloseableHttpResponse>();
        public final Map<String, RuntimeException> errors = new HashMap<String, RuntimeException>();

        public MultipartRequestMatcher() {
            this.responses.put("200:OK", DigipostApiMock.this.defaultResponse);
            this.errors.put("CONNECTION_REFUSED", new RuntimeException(new ConnectException("Connection refused")));
        }

        @Override
        public CloseableHttpResponse findResponse(String requestString) {
            if (this.responses.containsKey(requestString)) {
                return this.responses.get(requestString);
            }
            if (this.errors.containsKey(requestString)) {
                throw this.errors.get(requestString);
            }
            if (requestString.matches("^[0-9]{3}:(.)+")) {
                String[] split = requestString.split(":");
                if (ErrorCode.isKnown(split[1])) {
                    ErrorCode errorCode = ErrorCode.resolve(split[1]);
                    ErrorType translated = (ErrorType)EnumUtils.getEnum(ErrorType.class, (String)errorCode.getOverriddenErrorType().name());
                    ByteArrayOutputStream bao = new ByteArrayOutputStream();
                    JAXBContextUtils.marshal(JAXBContextUtils.jaxbContext, new ErrorMessage(translated != null ? translated : ErrorType.SERVER, errorCode.name(), "Generic error-message from digipost-api-client-mock", new Link[0]), (OutputStream)bao);
                    return MockfriendlyResponse.MockedResponseBuilder.create().status(Integer.parseInt(split[0])).entity((HttpEntity)new ByteArrayEntity(bao.toByteArray())).build();
                }
                throw new IllegalArgumentException("ErrorCode " + split[1] + " is unknown");
            }
            return DigipostApiMock.this.defaultResponse;
        }
    }

    public static class MockRequest {
        private final String key;

        public MockRequest(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }

    public static class MockResponse
    implements ResponseProducer {
        private CloseableHttpResponse response;
        private RuntimeException exception;

        public MockResponse(CloseableHttpResponse response) {
            this.response = response;
        }

        public MockResponse(RuntimeException ex) {
            this.exception = ex;
        }

        @Override
        public CloseableHttpResponse getResponse() {
            if (this.exception != null) {
                throw this.exception;
            }
            return this.response;
        }
    }

    public static interface ResponseProducer {
        public CloseableHttpResponse getResponse();
    }

    public static class RequestsAndResponses {
        private final Queue<ResponseProducer> responseQueue = new ConcurrentLinkedQueue<ResponseProducer>();
        private final RequestMatcher requestMatcher;
        private final Map<String, MockRequest> requestMap;

        RequestsAndResponses() {
            this(RequestMatcher.NO_OP);
        }

        RequestsAndResponses(RequestMatcher requestMatcher) {
            this.requestMatcher = requestMatcher;
            this.requestMap = Collections.synchronizedMap(new LinkedHashMap<String, MockRequest>(){

                @Override
                protected boolean removeEldestEntry(Map.Entry<String, MockRequest> eldest) {
                    return this.size() > 100;
                }
            });
        }

        public void addExpectedResponse(CloseableHttpResponse response) {
            this.responseQueue.add(new MockResponse(response));
        }

        public void addExpectedException(RuntimeException ex) {
            this.responseQueue.add(new MockResponse(ex));
        }

        public CloseableHttpResponse getResponse() {
            return this.getResponse("default");
        }

        public CloseableHttpResponse getResponse(String requestString) {
            ResponseProducer response = this.responseQueue.poll();
            if (response != null) {
                return response.getResponse();
            }
            return this.requestMatcher.findResponse(requestString);
        }

        public void addRequest(MockRequest request) {
            this.requestMap.put(request.getKey(), request);
        }

        public MockRequest getRequest(String requestKey) {
            return this.requestMap.get(requestKey);
        }

        public Map<String, MockRequest> getRequests() {
            return this.requestMap;
        }
    }

    @FunctionalInterface
    public static interface RequestMatcher {
        public static final RequestMatcher NO_OP = requestString -> null;

        public CloseableHttpResponse findResponse(String var1);
    }

    public static enum Method {
        SEND_MULTIPART_MESSAGE,
        GET_PRINT_CERTIFICATE,
        GET_SENDER_INFORMATION,
        GET_CONTENT,
        MULTIPART_MESSAGE,
        GET_DOCUMENTS_EVENTS,
        GET_DOCUMENT_STATUS,
        IDENTIFY_RECIPIENT;

    }
}

