/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.testing;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.time.Clock;
import java.util.HashMap;
import java.util.Map;
import java.util.function.UnaryOperator;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import no.digipost.api.client.BrokerId;
import no.digipost.api.client.DigipostClient;
import no.digipost.api.client.DigipostClientConfig;
import no.digipost.api.client.errorhandling.DigipostClientException;
import no.digipost.api.client.errorhandling.ErrorCode;
import no.digipost.api.client.testing.DigipostApiMock;
import no.digipost.api.client.testing.UnusedPortFinder;
import no.digipost.http.client3.DigipostHttpClientFactory;
import no.digipost.http.client3.DigipostHttpClientSettings;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.impl.client.HttpClientBuilder;
import org.xml.sax.ContentHandler;

public class DigipostClientMock {
    public final Map<DigipostApiMock.Method, DigipostApiMock.RequestsAndResponses> requestsAndResponsesMap = new HashMap<DigipostApiMock.Method, DigipostApiMock.RequestsAndResponses>();
    private final DigipostClient client;
    private final int port = UnusedPortFinder.getNextAvailablePort(6666, 6676);
    private static final Clock clock = Clock.systemDefaultZone();
    private static final DigipostApiMock digipostApiMock = new DigipostApiMock(clock);
    private static final String KEY_STORE_PASSWORD = "Qwer12345";
    private static final String KEY_STORE_ALIAS = "apiTest";

    public DigipostClientMock() {
        this(UnaryOperator.identity());
    }

    public DigipostClientMock(UnaryOperator<DigipostHttpClientSettings> clientCustomizer) {
        URI host = URI.create("http://localhost:" + this.port);
        HttpClientBuilder httpClientBuilder = DigipostHttpClientFactory.createBuilder((DigipostHttpClientSettings)((DigipostHttpClientSettings)clientCustomizer.apply(DigipostHttpClientSettings.DEFAULT)));
        DigipostClientConfig config = DigipostClientConfig.newConfiguration().clock(clock).digipostApiUri(host).build();
        this.client = new DigipostClient(config, BrokerId.of(1L), data -> new byte[0], httpClientBuilder);
    }

    public void start() {
        KeyPair keyPair = DigipostClientMock.getKeyPair(KEY_STORE_ALIAS, KEY_STORE_PASSWORD);
        digipostApiMock.start(this.port, this.requestsAndResponsesMap, keyPair);
    }

    public static KeyPair getKeyPair(String alias, String password) {
        try {
            KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            keystore.load(DigipostClientMock.class.getResourceAsStream("/mockKeystore.jks"), KEY_STORE_PASSWORD.toCharArray());
            Key key = keystore.getKey(alias, password.toCharArray());
            Certificate cert = keystore.getCertificate(alias);
            PublicKey publicKey = cert.getPublicKey();
            return new KeyPair(publicKey, (PrivateKey)key);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void shutdownWebserver() {
        digipostApiMock.stop();
    }

    public DigipostClient getClient() {
        return this.client;
    }

    public Map<String, DigipostApiMock.MockRequest> getAllRequests(DigipostApiMock.Method method) {
        return this.requestsAndResponsesMap.get((Object)method).getRequests();
    }

    public DigipostApiMock.MockRequest getRequest(DigipostApiMock.Method method, String requestKey) {
        return this.requestsAndResponsesMap.get((Object)method).getRequest(requestKey);
    }

    public void addExpectedResponse(DigipostApiMock.Method method, CloseableHttpResponse response) {
        DigipostApiMock.RequestsAndResponses requestsAndResponses = this.requestsAndResponsesMap.get((Object)method);
        requestsAndResponses.addExpectedResponse(response);
    }

    public void addExpectedException(DigipostApiMock.Method method, RuntimeException exception) {
        DigipostApiMock.RequestsAndResponses requestsAndResponses = this.requestsAndResponsesMap.get((Object)method);
        requestsAndResponses.addExpectedException(exception);
    }

    public void reset() {
        digipostApiMock.init();
    }

    public static ValidatingMarshaller initMarshaller() {
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(DigipostClient.class.getResource("/xsd/api_v7.xsd"));
            return new ValidatingMarshaller(JAXBContext.newInstance((String)"no.digipost.api.client.representations"), schema);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class ValidatingMarshaller {
        private final JAXBContext jaxbContext;
        private final Schema schema;

        public ValidatingMarshaller(JAXBContext jaxbContext, Schema schema) {
            this.jaxbContext = jaxbContext;
            this.schema = schema;
        }

        public void marshal(Object jaxbElement, ContentHandler handler) {
            try {
                Marshaller marshaller = this.jaxbContext.createMarshaller();
                marshaller.setSchema(this.schema);
                marshaller.marshal(jaxbElement, handler);
            }
            catch (JAXBException e) {
                StringWriter w = new StringWriter();
                PrintWriter printWriter = new PrintWriter(w);
                e.printStackTrace(printWriter);
                throw new DigipostClientException(ErrorCode.PROBLEM_WITH_REQUEST, "DigipostClientMock failed to marshall the " + jaxbElement.getClass().getSimpleName() + " to xml.\n\n" + w.toString());
            }
        }
    }
}

