/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client;

import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.UUID;
import no.digipost.api.client.BrokerId;
import no.digipost.api.client.DigipostClientConfig;
import no.digipost.api.client.EventLogger;
import no.digipost.api.client.SenderId;
import no.digipost.api.client.delivery.MessageDeliveryApi;
import no.digipost.api.client.delivery.OngoingDelivery;
import no.digipost.api.client.document.DocumentApi;
import no.digipost.api.client.errorhandling.DigipostClientException;
import no.digipost.api.client.errorhandling.ErrorCode;
import no.digipost.api.client.inbox.InboxApi;
import no.digipost.api.client.internal.ApiServiceImpl;
import no.digipost.api.client.internal.delivery.MessageDeliverer;
import no.digipost.api.client.internal.http.response.HttpResponseUtils;
import no.digipost.api.client.representations.AddDataLink;
import no.digipost.api.client.representations.AdditionalData;
import no.digipost.api.client.representations.Autocomplete;
import no.digipost.api.client.representations.DocumentEvents;
import no.digipost.api.client.representations.DocumentStatus;
import no.digipost.api.client.representations.Identification;
import no.digipost.api.client.representations.IdentificationResult;
import no.digipost.api.client.representations.Link;
import no.digipost.api.client.representations.Message;
import no.digipost.api.client.representations.Recipients;
import no.digipost.api.client.representations.accounts.UserAccount;
import no.digipost.api.client.representations.accounts.UserInformation;
import no.digipost.api.client.representations.inbox.Inbox;
import no.digipost.api.client.representations.inbox.InboxDocument;
import no.digipost.api.client.representations.sender.SenderInformation;
import no.digipost.api.client.security.CryptoUtil;
import no.digipost.api.client.security.Signer;
import no.digipost.api.client.util.JAXBContextUtils;
import no.digipost.http.client3.DigipostHttpClientFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DigipostClient {
    private static final Logger LOG;
    private final EventLogger eventLogger;
    private final MessageDeliveryApi messageApi;
    private final MessageDeliverer messageSender;
    private final InboxApi inboxApiService;
    private final DocumentApi documentApi;

    public DigipostClient(DigipostClientConfig config, BrokerId brokerId, Signer signer) {
        this(config, brokerId, signer, DigipostHttpClientFactory.createDefaultBuilder());
    }

    public DigipostClient(DigipostClientConfig config, BrokerId brokerId, Signer signer, HttpClientBuilder clientBuilder) {
        this(config, new ApiServiceImpl(config, clientBuilder, brokerId, signer));
    }

    private DigipostClient(DigipostClientConfig config, ApiServiceImpl apiService) {
        this(config, apiService, apiService, apiService);
    }

    public DigipostClient(DigipostClientConfig config, MessageDeliveryApi apiService, InboxApi inboxApiService, DocumentApi documentApi) {
        this.messageApi = apiService;
        this.inboxApiService = inboxApiService;
        this.documentApi = documentApi;
        this.messageSender = new MessageDeliverer(config, apiService);
        this.eventLogger = config.eventLogger.withDebugLogTo(LOG);
    }

    public OngoingDelivery.WithPrintFallback createMessage(Message message) {
        return this.messageSender.createMessage(message);
    }

    public OngoingDelivery.ForPrintOnly createPrintOnlyMessage(Message printMessage) {
        return this.messageSender.createPrintOnlyMessage(printMessage);
    }

    public IdentificationResult identifyRecipient(Identification identification) {
        IdentificationResult identificationResult;
        block8: {
            CloseableHttpResponse response = this.messageApi.identifyRecipient(identification);
            try {
                HttpResponseUtils.checkResponse((HttpResponse)response, this.eventLogger);
                identificationResult = JAXBContextUtils.unmarshal(JAXBContextUtils.jaxbContext, response.getEntity().getContent(), IdentificationResult.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new DigipostClientException(ErrorCode.GENERAL_ERROR, (Throwable)e);
                }
            }
            response.close();
        }
        return identificationResult;
    }

    public void addData(AddDataLink addDataLink, AdditionalData data) {
        this.messageSender.addData(addDataLink, data);
    }

    public Recipients search(String searchString) {
        return this.messageApi.search(searchString);
    }

    public Autocomplete getAutocompleteSuggestions(String searchString) {
        return this.messageApi.searchSuggest(searchString);
    }

    public DocumentEvents getDocumentEvents(ZonedDateTime from, ZonedDateTime to, int offset, int maxResults) {
        return this.getDocumentEvents(null, null, from, to, offset, maxResults);
    }

    public DocumentEvents getDocumentEvents(String organisation, String partId, ZonedDateTime from, ZonedDateTime to, int offset, int maxResults) {
        return this.documentApi.getDocumentEvents(organisation, partId, from, to, offset, maxResults);
    }

    public SenderInformation getSenderInformation(SenderId senderId) {
        return this.messageApi.getSenderInformation(senderId);
    }

    public SenderInformation getSenderInformation(String orgnr, String avsenderenhet) {
        return this.messageApi.getSenderInformation(orgnr, avsenderenhet);
    }

    public DocumentStatus getDocumentStatus(Link linkToDocumentStatus) {
        return this.documentApi.getDocumentStatus(linkToDocumentStatus);
    }

    public DocumentStatus getDocumentStatus(SenderId senderId, UUID uuid) {
        return this.documentApi.getDocumentStatus(senderId, uuid);
    }

    public InputStream getContent(String path) {
        return this.documentApi.getDocumentContent(path);
    }

    public Inbox getInbox(SenderId senderId) {
        return this.getInbox(senderId, 0, 100);
    }

    public Inbox getInbox(SenderId senderId, int offset, int limit) {
        return this.inboxApiService.getInbox(senderId, offset, limit);
    }

    public InputStream getInboxDocumentContent(InboxDocument inboxDocument) {
        return this.inboxApiService.getInboxDocumentContentStream(inboxDocument);
    }

    public void deleteInboxDocument(InboxDocument inboxDocument) {
        this.inboxApiService.deleteInboxDocument(inboxDocument);
    }

    public UserAccount createOrActivateUserAccount(SenderId senderId, UserInformation user) {
        return this.messageApi.createOrActivateUserAccount(senderId, user);
    }

    static {
        CryptoUtil.addBouncyCastleProviderAndVerify_AES256_CBC_Support();
        LOG = LoggerFactory.getLogger(DigipostClient.class);
    }
}

