/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.xml.bind.JAXB;
import no.digipost.api.client.BrokerId;
import no.digipost.api.client.DigipostClientConfig;
import no.digipost.api.client.EventLogger;
import no.digipost.api.client.SenderId;
import no.digipost.api.client.delivery.MessageDeliveryApi;
import no.digipost.api.client.document.DocumentApi;
import no.digipost.api.client.errorhandling.DigipostClientException;
import no.digipost.api.client.errorhandling.ErrorCode;
import no.digipost.api.client.inbox.InboxApi;
import no.digipost.api.client.internal.Cached;
import no.digipost.api.client.internal.ExceptionUtils;
import no.digipost.api.client.internal.http.Headers;
import no.digipost.api.client.internal.http.MultipartNoLengthCheckHttpEntity;
import no.digipost.api.client.internal.http.UriUtils;
import no.digipost.api.client.internal.http.request.interceptor.RequestContentHashFilter;
import no.digipost.api.client.internal.http.request.interceptor.RequestDateInterceptor;
import no.digipost.api.client.internal.http.request.interceptor.RequestSignatureInterceptor;
import no.digipost.api.client.internal.http.request.interceptor.RequestUserAgentInterceptor;
import no.digipost.api.client.internal.http.response.HttpResponseUtils;
import no.digipost.api.client.internal.http.response.interceptor.ResponseContentSHA256Interceptor;
import no.digipost.api.client.internal.http.response.interceptor.ResponseDateInterceptor;
import no.digipost.api.client.internal.http.response.interceptor.ResponseSignatureInterceptor;
import no.digipost.api.client.representations.AddDataLink;
import no.digipost.api.client.representations.AdditionalData;
import no.digipost.api.client.representations.Autocomplete;
import no.digipost.api.client.representations.DocumentEvents;
import no.digipost.api.client.representations.DocumentStatus;
import no.digipost.api.client.representations.EntryPoint;
import no.digipost.api.client.representations.ErrorMessage;
import no.digipost.api.client.representations.Identification;
import no.digipost.api.client.representations.Link;
import no.digipost.api.client.representations.MayHaveSender;
import no.digipost.api.client.representations.Recipients;
import no.digipost.api.client.representations.accounts.UserAccount;
import no.digipost.api.client.representations.accounts.UserInformation;
import no.digipost.api.client.representations.inbox.Inbox;
import no.digipost.api.client.representations.inbox.InboxDocument;
import no.digipost.api.client.representations.sender.AuthorialSender;
import no.digipost.api.client.representations.sender.SenderInformation;
import no.digipost.api.client.security.Digester;
import no.digipost.api.client.security.Signer;
import no.digipost.api.client.util.JAXBContextUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpCoreContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiServiceImpl
implements MessageDeliveryApi,
InboxApi,
DocumentApi {
    private static final Logger LOG = LoggerFactory.getLogger(ApiServiceImpl.class);
    private static final String ENTRY_POINT = "/";
    private final BrokerId brokerId;
    private final CloseableHttpClient httpClient;
    private final URI digipostUrl;
    private final Cached cached;
    private final EventLogger eventLogger;
    private static final DateTimeFormatter DATE_TIME_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSxxx");

    public ApiServiceImpl(DigipostClientConfig config, HttpClientBuilder httpClientBuilder, BrokerId brokerId, Signer signer) {
        this.brokerId = brokerId;
        this.eventLogger = config.eventLogger.withDebugLogTo(LOG);
        this.digipostUrl = config.digipostApiUri;
        this.cached = new Cached(this::fetchEntryPoint);
        this.httpClient = httpClientBuilder.addInterceptorLast((HttpRequestInterceptor)new RequestDateInterceptor(config.eventLogger, config.clock)).addInterceptorLast((HttpRequestInterceptor)new RequestUserAgentInterceptor()).addInterceptorLast((HttpRequestInterceptor)new RequestSignatureInterceptor(signer, config.eventLogger, new RequestContentHashFilter(config.eventLogger, Digester.sha256, "X-Content-SHA256"))).addInterceptorLast((HttpResponseInterceptor)new ResponseDateInterceptor(config.clock)).addInterceptorLast((HttpResponseInterceptor)new ResponseContentSHA256Interceptor()).addInterceptorLast((HttpResponseInterceptor)new ResponseSignatureInterceptor(this::getEntryPoint)).build();
        this.eventLogger.log("Initialiserte apache-klient mot " + config.digipostApiUri);
    }

    public EntryPoint getEntryPoint() {
        return (EntryPoint)this.cached.entryPoint.get();
    }

    @Override
    public CloseableHttpResponse sendMultipartMessage(HttpEntity multipart) {
        MultipartNoLengthCheckHttpEntity multipartLengthCheckHttpEntity = new MultipartNoLengthCheckHttpEntity(multipart);
        EntryPoint entryPoint = this.getEntryPoint();
        HttpPost httpPost = new HttpPost(this.digipostUrl.resolve(entryPoint.getCreateMessageUri().getPath()));
        httpPost.setHeader(Headers.Accept_DIGIPOST_MEDIA_TYPE_V7);
        httpPost.setHeader("MIME-Version", "1.0");
        httpPost.removeHeaders("Accept-Encoding");
        httpPost.setEntity((HttpEntity)multipartLengthCheckHttpEntity);
        return this.send((HttpRequestBase)httpPost);
    }

    @Override
    public CloseableHttpResponse identifyAndGetEncryptionKey(Identification identification) {
        EntryPoint entryPoint = this.getEntryPoint();
        return this.sendDigipostMedia(identification, entryPoint.getIdentificationWithEncryptionKeyUri().getPath());
    }

    @Override
    public CloseableHttpResponse getEncryptionKey(URI location) {
        HttpGet httpGet = new HttpGet(location);
        httpGet.setHeader(Headers.Accept_DIGIPOST_MEDIA_TYPE_V7);
        return this.send((HttpRequestBase)httpGet);
    }

    @Override
    public CloseableHttpResponse getEncryptionCertificateForPrint() {
        EntryPoint entryPoint = this.getEntryPoint();
        HttpGet httpGet = new HttpGet(this.digipostUrl.resolve(entryPoint.getPrintEncryptionCertificate().getPath()));
        httpGet.setHeader(Headers.Accept_DIGIPOST_MEDIA_TYPE_V7);
        return this.send((HttpRequestBase)httpGet);
    }

    @Override
    public CloseableHttpResponse addData(AddDataLink addDataLink, AdditionalData data) {
        return this.sendDigipostMedia(data, addDataLink.getPath());
    }

    @Override
    public DocumentEvents getDocumentEvents(String organisation, String partId, ZonedDateTime from, ZonedDateTime to, int offset, int maxResults) {
        URIBuilder builder = new URIBuilder(this.digipostUrl.resolve(this.getEntryPoint().getDocumentEventsUri().getPath())).setParameter("from", DATE_TIME_FORMAT.format(from)).setParameter("to", DATE_TIME_FORMAT.format(to)).setParameter("offset", String.valueOf(offset)).setParameter("maxResults", String.valueOf(maxResults));
        if (organisation != null) {
            builder = builder.setParameter("org", organisation);
        }
        if (partId != null) {
            builder = builder.setParameter("part", partId);
        }
        try {
            HttpGet httpGet = new HttpGet(builder.build());
            return this.requestEntity((HttpRequestBase)httpGet, DocumentEvents.class);
        }
        catch (URISyntaxException e) {
            throw ExceptionUtils.asUnchecked(e);
        }
    }

    @Override
    public DocumentStatus getDocumentStatus(Link linkToDocumentStatus) {
        return this.getDocumentStatus(linkToDocumentStatus.getUri().getPath());
    }

    @Override
    public DocumentStatus getDocumentStatus(SenderId senderId, UUID uuid) {
        return this.getDocumentStatus("/documents/" + senderId.stringValue() + ENTRY_POINT + uuid + "/status");
    }

    private DocumentStatus getDocumentStatus(String path) {
        HttpGet httpGet = new HttpGet(this.digipostUrl.resolve(path));
        return this.requestEntity((HttpRequestBase)httpGet, DocumentStatus.class);
    }

    @Override
    public InputStream getDocumentContent(String path) {
        HttpGet httpGet = new HttpGet(this.digipostUrl.resolve(path));
        return this.requestStream((HttpRequestBase)httpGet);
    }

    @Override
    public Recipients search(String searchString) {
        HttpGet httpGet = new HttpGet(this.digipostUrl.resolve(ApiServiceImpl.createEncodedURIPath(this.getEntryPoint().getSearchUri().getPath() + ENTRY_POINT + searchString)));
        return this.requestEntity((HttpRequestBase)httpGet, Recipients.class);
    }

    @Override
    public Autocomplete searchSuggest(String searchString) {
        HttpGet httpGet = new HttpGet(this.digipostUrl.resolve(ApiServiceImpl.createEncodedURIPath(this.getEntryPoint().getAutocompleteUri().getPath() + ENTRY_POINT + searchString)));
        return this.requestEntity((HttpRequestBase)httpGet, Autocomplete.class);
    }

    @Override
    public CloseableHttpResponse identifyRecipient(Identification identification) {
        return this.sendDigipostMedia(identification, this.getEntryPoint().getIdentificationUri().getPath());
    }

    private EntryPoint fetchEntryPoint() throws IOException {
        HttpGet httpGet = new HttpGet(this.digipostUrl.resolve(ENTRY_POINT));
        httpGet.setHeader(Headers.Accept_DIGIPOST_MEDIA_TYPE_V7);
        HttpCoreContext httpCoreContext = HttpCoreContext.create();
        httpCoreContext.setAttribute("NOT_SIGNED_RESPONSE", (Object)true);
        try (CloseableHttpResponse response = this.send((HttpRequestBase)httpGet, (HttpContext)httpCoreContext);){
            if (response.getStatusLine().getStatusCode() == 200) {
                EntryPoint entryPoint = JAXBContextUtils.unmarshal(JAXBContextUtils.jaxbContext, response.getEntity().getContent(), EntryPoint.class);
                return entryPoint;
            }
            ErrorMessage errorMessage = JAXBContextUtils.unmarshal(JAXBContextUtils.jaxbContext, response.getEntity().getContent(), ErrorMessage.class);
            throw new DigipostClientException(errorMessage);
        }
    }

    @Override
    public SenderInformation getSenderInformation(SenderId senderId) {
        return (SenderInformation)this.cached.senderInformation.get((Object)senderId.stringValue(), () -> this.getEntity(SenderInformation.class, this.getEntryPoint().getSenderInformationUri().getPath() + ENTRY_POINT + senderId.stringValue()));
    }

    @Override
    public SenderInformation getSenderInformation(String orgnr, String avsenderenhet) {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("org_id", orgnr);
        if (avsenderenhet != null) {
            queryParams.put("part_id", avsenderenhet);
        }
        return (SenderInformation)this.cached.senderInformation.get((Object)(orgnr + Optional.ofNullable(avsenderenhet).map(enhet -> "-" + enhet).orElse("")), () -> this.getEntity(SenderInformation.class, this.getEntryPoint().getSenderInformationUri().getPath(), queryParams));
    }

    @Override
    public SenderInformation getSenderInformation(MayHaveSender mayHaveSender) {
        AuthorialSender authorialSender = AuthorialSender.resolve(this.brokerId, mayHaveSender);
        if (authorialSender.is(AuthorialSender.Type.ACCOUNT_ID)) {
            return this.getSenderInformation(authorialSender.getAccountId());
        }
        return this.getSenderInformation(authorialSender.getOrganization().organizationId, authorialSender.getOrganization().partId);
    }

    @Override
    public Inbox getInbox(SenderId senderId, int offset, int limit) {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("offset", String.valueOf(offset));
        queryParams.put("limit", String.valueOf(limit));
        return this.getEntity(Inbox.class, ENTRY_POINT + senderId.stringValue() + "/inbox", queryParams);
    }

    @Override
    public InputStream getInboxDocumentContentStream(InboxDocument inboxDocument) {
        HttpGet httpGet = new HttpGet(inboxDocument.getContentUri());
        httpGet.setHeader("Accept", ContentType.WILDCARD.toString());
        HttpCoreContext httpCoreContext = HttpCoreContext.create();
        httpCoreContext.setAttribute("NOT_SIGNED_RESPONSE", (Object)true);
        return this.requestStream((HttpRequestBase)httpGet);
    }

    @Override
    public void deleteInboxDocument(InboxDocument inboxDocument) {
        this.send((HttpRequestBase)new HttpDelete(inboxDocument.getDeleteUri()));
    }

    @Override
    public UserAccount createOrActivateUserAccount(SenderId senderId, UserInformation user) {
        HttpPost httpPost = new HttpPost(this.digipostUrl.resolve(ENTRY_POINT + senderId.stringValue() + "/user-accounts"));
        httpPost.setHeader(Headers.Content_Type_DIGIPOST_MEDIA_TYPE_V7);
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        JAXBContextUtils.marshal(JAXBContextUtils.jaxbContext, user, (OutputStream)bao);
        httpPost.setEntity((HttpEntity)new ByteArrayEntity(bao.toByteArray()));
        return this.requestEntity((HttpRequestBase)httpPost, UserAccount.class);
    }

    private static URI createEncodedURIPath(String path) {
        try {
            return new URI(null, null, path, null);
        }
        catch (URISyntaxException e) {
            throw new DigipostClientException(ErrorCode.GENERAL_ERROR, "Error encoding search path because of " + ExceptionUtils.exceptionNameAndMessage(e), e);
        }
    }

    private <R> R getEntity(Class<R> entityType, String resourcePath) {
        return this.requestEntity((HttpRequestBase)new HttpGet(this.digipostUrl.resolve(resourcePath)), entityType);
    }

    private <R> R getEntity(Class<R> entityType, String resourcePath, Map<String, ?> queryParams) {
        HttpGet httpGet = new HttpGet(UriUtils.withQueryParams(this.digipostUrl.resolve(resourcePath), queryParams));
        return this.requestEntity((HttpRequestBase)httpGet, entityType);
    }

    private <R> InputStream requestStream(HttpRequestBase request) {
        return this.request(request, InputStream.class, new Header[0]);
    }

    private <R> R requestEntity(HttpRequestBase request, Class<R> entityType) {
        return this.request(request, entityType, Headers.Accept_DIGIPOST_MEDIA_TYPE_V7);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <R> R request(HttpRequestBase request, Class<R> entityType, Header ... headers) {
        for (Header header : headers) {
            request.setHeader(header);
        }
        if (entityType == InputStream.class) {
            InputStream responseStream = HttpResponseUtils.safelyOfferEntityStreamExternally(this.send(request), this.eventLogger);
            return (R)responseStream;
        }
        try (CloseableHttpResponse response = this.send(request);){
            HttpResponseUtils.checkResponse((HttpResponse)response, this.eventLogger);
            Object object = JAXB.unmarshal((InputStream)response.getEntity().getContent(), entityType);
            return (R)object;
        }
        catch (IOException e) {
            throw new DigipostClientException(ErrorCode.GENERAL_ERROR, e.getMessage(), e);
        }
    }

    private CloseableHttpResponse send(HttpRequestBase request) {
        return this.send(request, null);
    }

    private CloseableHttpResponse send(HttpRequestBase request, HttpContext context) {
        try {
            request.setHeader("X-Digipost-UserId", this.brokerId.stringValue());
            if (context == null) {
                return this.httpClient.execute((HttpUriRequest)request);
            }
            return this.httpClient.execute((HttpUriRequest)request, context);
        }
        catch (IOException e) {
            throw ExceptionUtils.asUnchecked(e);
        }
    }

    private CloseableHttpResponse sendDigipostMedia(Object data, String uri) {
        HttpPost httpPost = new HttpPost(this.digipostUrl.resolve(uri));
        httpPost.setHeader(Headers.Accept_DIGIPOST_MEDIA_TYPE_V7);
        httpPost.setHeader(Headers.Content_Type_DIGIPOST_MEDIA_TYPE_V7);
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        JAXBContextUtils.marshal(JAXBContextUtils.jaxbContext, data, (OutputStream)bao);
        httpPost.setEntity((HttpEntity)new ByteArrayEntity(bao.toByteArray()));
        return this.send((HttpRequestBase)httpPost);
    }
}

