/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.cache2.fallback;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface FallbackKeeperFailedHandler<K, V> {
    public void handle(K var1, V var2, Exception var3);

    public static class FallbackWriteFailed
    extends RuntimeException {
        private FallbackWriteFailed(Exception cause, Object cacheKey, Object value) {
            super("Writing fall-back value failed, and '" + value + "', which was successfully retrieved from the underlying loader, will not be loaded into the cache.", cause);
        }
    }

    public static class Rethrow
    implements FallbackKeeperFailedHandler<Object, Object> {
        @Override
        public void handle(Object cacheKey, Object value, Exception cause) {
            throw new FallbackWriteFailed(cause, cacheKey, value);
        }
    }

    public static class LogAsError
    implements FallbackKeeperFailedHandler<Object, Object> {
        private static final Logger LOG = LoggerFactory.getLogger(LogAsError.class);

        @Override
        public void handle(Object cacheKey, Object value, Exception cause) {
            LOG.error("Failed to write cache-value for key '{}' to disk for use as fallback because {}: '{}', but will still return value from underlying cache-loader. Writing this fallback value will not be re-attempted until next time cache expires and successfully loads from underlying cache-loader.", new Object[]{cacheKey, cause.getClass().getSimpleName(), cause.getMessage(), cause});
        }
    }
}

