/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.cache2.fallback;

import no.digipost.cache2.fallback.FallbackKeeper;
import no.digipost.cache2.fallback.FallbackKeeperFailedHandler;
import no.digipost.cache2.loader.Loader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoaderWithFallback<K, V>
implements Loader<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(LoaderWithFallback.class);
    private final Loader<? super K, V> cacheLoader;
    private final Loader<? super K, V> fallbackLoader;
    private final FallbackKeeper<? super K, ? super V> fallbackKeeper;
    private final FallbackKeeperFailedHandler<? super K, ? super V> fallbackWriterFailedHandler;

    public LoaderWithFallback(Loader<? super K, V> cacheLoader, Loader<? super K, V> fallbackLoader, FallbackKeeperFailedHandler<? super K, ? super V> fallbackWriteFailedHandler) {
        this(cacheLoader, fallbackLoader, FallbackKeeper.NO_KEEPING, fallbackWriteFailedHandler);
    }

    public LoaderWithFallback(Loader<? super K, V> cacheLoader, Loader<? super K, V> fallbackLoader, FallbackKeeper<? super K, ? super V> fallbackKeeper, FallbackKeeperFailedHandler<? super K, ? super V> fallbackWriteFailedHandler) {
        this.cacheLoader = cacheLoader;
        this.fallbackLoader = fallbackLoader;
        this.fallbackKeeper = fallbackKeeper;
        this.fallbackWriterFailedHandler = fallbackWriteFailedHandler;
    }

    @Override
    public V load(K key) throws Exception {
        V newCacheContent;
        try {
            newCacheContent = this.cacheLoader.load(key);
        }
        catch (Exception loaderFailedException) {
            return this.tryRecoverFailingLoader(key, loaderFailedException);
        }
        try {
            this.fallbackKeeper.keep(key, newCacheContent);
        }
        catch (Exception e) {
            this.fallbackWriterFailedHandler.handle(key, newCacheContent, e);
        }
        return newCacheContent;
    }

    private V tryRecoverFailingLoader(K key, Exception loaderFailedException) throws Exception {
        LOG.warn("Failed to load cache-value from wrapped cache-loader because {}: '{}'. Attempting to load from disk as fallback mechanism. Enable debug-level to see stacktrace.", (Object)loaderFailedException.getClass().getSimpleName(), (Object)loaderFailedException.getMessage());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Stacktrace for failing cache loading:", (Throwable)loaderFailedException);
        }
        try {
            return this.fallbackLoader.load(key);
        }
        catch (Exception fallbackLoadException) {
            loaderFailedException.addSuppressed(fallbackLoadException);
            LOG.warn("Regular cache value loading failed because {}: '{}', and attempt to read fallback value from disk also failed because {}: '{}'", new Object[]{loaderFailedException.getClass().getSimpleName(), loaderFailedException.getMessage(), fallbackLoadException.getClass().getSimpleName(), fallbackLoadException.getMessage()});
            throw loaderFailedException;
        }
    }
}

