/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.cache2.fallback.disk;

import java.io.OutputStream;
import no.digipost.cache2.fallback.FallbackKeeper;
import no.digipost.cache2.fallback.disk.FallbackFile;
import no.digipost.cache2.fallback.marshall.Marshaller;

class DiskFallbackKeeper<K, V>
implements FallbackKeeper<K, V> {
    private FallbackFile.Resolver<K> fileResolver;
    private Marshaller<V> marshaller;

    public DiskFallbackKeeper(FallbackFile.Resolver<K> fileResolver, Marshaller<V> marshaller) {
        this.fileResolver = fileResolver;
        this.marshaller = marshaller;
    }

    @Override
    public void keep(K key, V value) throws Exception {
        FallbackFile fallbackFile = this.fileResolver.resolveFor(key);
        this.fileResolver.resolveFor(key).lockedFile.runIfLock(() -> {
            try (OutputStream out = fallbackFile.write();){
                this.marshaller.write(value, out);
            }
        });
    }
}

