/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.cache2.fallback.disk;

import java.io.InputStream;
import no.digipost.cache2.fallback.disk.FallbackFile;
import no.digipost.cache2.fallback.marshall.Marshaller;
import no.digipost.cache2.loader.Loader;

public class DiskFallbackLoader<K, V>
implements Loader<K, V> {
    private final FallbackFile.Resolver<K> fileResolver;
    private final Marshaller<V> marshaller;

    DiskFallbackLoader(FallbackFile.Resolver<K> fileResolver, Marshaller<V> marshaller) {
        this.fileResolver = fileResolver;
        this.marshaller = marshaller;
    }

    @Override
    public V load(K key) throws Exception {
        try (InputStream fallbackContent = this.fileResolver.resolveFor(key).read();){
            V v = this.marshaller.read(fallbackContent);
            return v;
        }
    }
}

