/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.cache2.fallback.disk;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.security.SecureRandom;
import java.time.Clock;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import no.digipost.cache2.fallback.disk.FallbackFileNamingStrategy;
import no.digipost.cache2.fallback.disk.LockedFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FallbackFile {
    private static final Logger LOG = LoggerFactory.getLogger(FallbackFile.class);
    public final LockedFile lockedFile;
    private final Random random = new SecureRandom();
    private final AtomicBoolean written;

    FallbackFile(LockedFile file) {
        this.lockedFile = file;
        this.written = new AtomicBoolean(Files.exists(file.getPath(), new LinkOption[0]));
    }

    public InputStream read() throws IOException {
        Path file = this.lockedFile.getPath();
        boolean fallbackFileExists = Files.exists(file, new LinkOption[0]);
        this.written.compareAndSet(false, fallbackFileExists);
        if (!this.written.get()) {
            throw new FallbackFileNotYetCreated(file);
        }
        if (!fallbackFileExists) {
            throw new FileNotFoundException("File " + file + " not found, even though it is supposed to have been written.");
        }
        return Files.newInputStream(file, new OpenOption[0]);
    }

    public OutputStream write() throws IOException {
        final Path tempfile = this.getTempfile();
        if (Files.exists(tempfile, new LinkOption[0])) {
            throw new FileAlreadyExistsException(tempfile.toString(), null, "Temp-file used for writing cache already exists. This is a bug. The algorithm for generating temp-file path needs improving.");
        }
        final OutputStream stream = Files.newOutputStream(tempfile, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
        return new OutputStream(){
            final AtomicBoolean closed = new AtomicBoolean(false);

            @Override
            public void write(int b) throws IOException {
                stream.write(b);
            }

            @Override
            public void close() throws IOException {
                if (this.closed.getAndSet(true)) {
                    return;
                }
                try {
                    stream.close();
                    Path file = FallbackFile.this.lockedFile.getPath();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Done writing cachevalue to disk. Comitting by renaming {} to {} (directory: {})", new Object[]{tempfile.getFileName(), file.getFileName(), file.getParent()});
                    }
                    Files.move(tempfile, file, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
                    FallbackFile.this.written.set(true);
                }
                finally {
                    Files.deleteIfExists(tempfile);
                }
            }
        };
    }

    public String toString() {
        return "Fallback-file " + this.lockedFile.getPath();
    }

    private Path getTempfile() {
        Path file = this.lockedFile.getPath();
        return file.resolveSibling(file.getFileName() + "." + System.currentTimeMillis() + "." + this.randomString(10));
    }

    private String randomString(int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            sb.append((char)(this.random.nextInt(25) + 97));
        }
        return sb.toString();
    }

    public static class FallbackFileNotYetCreated
    extends IOException {
        private FallbackFileNotYetCreated(Path file) {
            super("The fallback file " + file + " has not been created yet. This may happen in rare circumstances if the Loader has never successfully produced any value.");
        }
    }

    public static class Resolver<K> {
        private final Path directory;
        private final FallbackFileNamingStrategy<? super K> fileNamingStrategy;
        private final Clock clock;

        public Resolver(Path directory, FallbackFileNamingStrategy<? super K> fileNamingStrategy, Clock clock) {
            this.directory = directory;
            this.fileNamingStrategy = fileNamingStrategy;
            this.clock = clock;
        }

        public FallbackFile resolveFor(K cacheKey) {
            return new FallbackFile(new LockedFile(this.directory.resolve(this.fileNamingStrategy.toFilename(cacheKey)), this.clock));
        }
    }
}

