/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.cache2.fallback.disk;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Clock;
import no.digipost.cache2.fallback.FallbackKeeperFailedHandler;
import no.digipost.cache2.fallback.LoaderWithFallback;
import no.digipost.cache2.fallback.disk.DiskFallbackKeeper;
import no.digipost.cache2.fallback.disk.DiskFallbackLoader;
import no.digipost.cache2.fallback.disk.FallbackFile;
import no.digipost.cache2.fallback.disk.FallbackFileNamingStrategy;
import no.digipost.cache2.fallback.marshall.Marshaller;
import no.digipost.cache2.loader.Loader;
import no.digipost.cache2.loader.LoaderDecorator;

public class LoaderWithDiskFallbackDecorator<K, V>
implements LoaderDecorator<K, V> {
    private final Path fallbackDirectory;
    private final FallbackFileNamingStrategy<? super K> fallbackFileNamingStrategy;
    private final Marshaller<V> marshaller;
    private final FallbackKeeperFailedHandler<? super K, ? super V> fallbackWriteFailedHandler;
    private final Clock clock;

    public LoaderWithDiskFallbackDecorator(Path fallbackDirectory, FallbackFileNamingStrategy<? super K> fallbackFileNamingStrategy, Marshaller<V> marshaller) {
        this(fallbackDirectory, fallbackFileNamingStrategy, marshaller, new FallbackKeeperFailedHandler.LogAsError());
    }

    public LoaderWithDiskFallbackDecorator(Path fallbackDirectory, FallbackFileNamingStrategy<? super K> fallbackFileNamingStrategy, Marshaller<V> marshaller, FallbackKeeperFailedHandler<? super K, ? super V> fallbackWriteFailedHandler) {
        this(fallbackDirectory, fallbackFileNamingStrategy, marshaller, fallbackWriteFailedHandler, Clock.systemDefaultZone());
    }

    public LoaderWithDiskFallbackDecorator(Path fallbackDirectory, FallbackFileNamingStrategy<? super K> fallbackFileNamingStrategy, Marshaller<V> marshaller, FallbackKeeperFailedHandler<? super K, ? super V> fallbackWriteFailedHandler, Clock clock) {
        this.fallbackDirectory = fallbackDirectory;
        this.fallbackFileNamingStrategy = fallbackFileNamingStrategy;
        this.marshaller = marshaller;
        this.fallbackWriteFailedHandler = fallbackWriteFailedHandler;
        this.clock = clock;
    }

    @Override
    public Loader<K, V> decorate(Loader<? super K, V> loader) {
        FallbackFile.Resolver<? super K> resolver = new FallbackFile.Resolver<K>(this.fallbackDirectory, this.fallbackFileNamingStrategy, this.clock);
        if (Files.isRegularFile(this.fallbackDirectory, new LinkOption[0])) {
            throw new IllegalStateException(this.fallbackDirectory + " should either be non-existing or a directory, but refers to an existing file.");
        }
        try {
            Files.createDirectories(this.fallbackDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to prepare the directory to store cache values for fallback: " + e.getClass().getSimpleName() + " '" + e.getMessage() + "'", e);
        }
        return new LoaderWithFallback<K, V>(loader, new DiskFallbackLoader<K, V>(resolver, this.marshaller), new DiskFallbackKeeper<K, V>(resolver, this.marshaller), this.fallbackWriteFailedHandler);
    }
}

