/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.cache2.inmemory;

import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import no.digipost.cache2.inmemory.CacheConfig;
import no.digipost.cache2.inmemory.CacheStats;
import no.digipost.cache2.loader.Callables;
import no.digipost.cache2.loader.Loader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Cache<K, V> {
    static final Logger LOG = LoggerFactory.getLogger(Cache.class);
    private com.github.benmanes.caffeine.cache.Cache<K, V> caffeineCache;
    private String name;

    public static <K, V> Cache<K, V> create(CacheConfig ... configurers) {
        return Cache.create(Arrays.asList(configurers));
    }

    public static <K, V> Cache<K, V> create(String name, CacheConfig ... configurers) {
        return Cache.create(name, Arrays.asList(configurers));
    }

    public static <K, V> Cache<K, V> create(List<CacheConfig> configurers) {
        return Cache.create("cache-" + UUID.randomUUID(), configurers);
    }

    public static <K, V> Cache<K, V> create(String name, List<CacheConfig> configurers) {
        ArrayList<CacheConfig> allConfigurers = new ArrayList<CacheConfig>();
        allConfigurers.add(CacheConfig.systemClockTicker);
        allConfigurers.add(CacheConfig.logRemoval);
        allConfigurers.addAll(configurers);
        return new Cache<K, V>(name, allConfigurers);
    }

    Cache(String name, List<CacheConfig> configurers) {
        LOG.info("Creating new cache: {}", (Object)name);
        Caffeine cacheBuilder = Caffeine.newBuilder();
        configurers.forEach(configurer -> configurer.configure((Caffeine<Object, Object>)cacheBuilder));
        this.caffeineCache = cacheBuilder.build();
        this.name = name;
    }

    public V get(K key, Callable<V> valueResolver) {
        return this.get(key, Callables.toLoader(valueResolver));
    }

    public V get(K key, Loader<? super K, V> valueResolver) {
        return (V)this.caffeineCache.get(key, k -> {
            Object value;
            LOG.debug("{} resolving value for key {}", (Object)this.name, k);
            try {
                value = valueResolver.load(k);
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception e) {
                throw new RuntimeException(this.getCauseDescription(e), e);
            }
            LOG.info("Loaded '{}' into '{}' cache for key '{}'", new Object[]{value, this.name, k});
            return value;
        });
    }

    private String getCauseDescription(Throwable cause) {
        return cause.getClass().getSimpleName() + ": " + cause.getMessage();
    }

    public void invalidateAll() {
        LOG.debug("Invalidating all in {} cache", (Object)this.name);
        this.caffeineCache.invalidateAll();
    }

    @SafeVarargs
    public final void invalidate(K ... keys) {
        this.invalidate((Iterable<? extends K>)Arrays.asList(keys));
    }

    public void invalidate(Iterable<? extends K> keys) {
        LOG.debug("Invalidating specific keys in {} cache", (Object)this.name);
        this.caffeineCache.invalidateAll(keys);
    }

    public CacheStats getCacheStats() {
        return CacheStats.fromCaffeineStats(this.caffeineCache.stats());
    }
}

