/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.cache2.inmemory;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Ticker;
import java.time.Clock;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import no.digipost.cache2.inmemory.Cache;
import no.digipost.cache2.inmemory.ConfiguresCaffeine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CacheConfig
implements ConfiguresCaffeine {
    private static final Logger LOG = LoggerFactory.getLogger(CacheConfig.class);
    public static final CacheConfig useSoftValues = CacheConfig.onCacheBuilder(builder -> {
        LOG.info("Using soft references for caching. See http://docs.oracle.com/javase/1.5.0/docs/api/java/lang/ref/SoftReference.html");
        return builder.softValues();
    });
    static final CacheConfig systemClockTicker = CacheConfig.clockTicker(Clock.systemDefaultZone());
    static final CacheConfig logRemoval = CacheConfig.onCacheBuilder(builder -> builder.removalListener((key, value, reason) -> Cache.LOG.info("Removing '{}' from cache (key={}). Cause: {}.", new Object[]{value, key, reason})));

    public static CacheConfig expireAfterAccess(Duration expiryTime) {
        return CacheConfig.onCacheBuilder(builder -> {
            LOG.info("Expires values {} ms after last access", (Object)expiryTime.toMillis());
            return builder.expireAfterAccess(expiryTime.toMillis(), TimeUnit.MILLISECONDS);
        });
    }

    public static CacheConfig expireAfterWrite(Duration expiryTime) {
        return CacheConfig.onCacheBuilder(builder -> {
            LOG.info("Expire values {} ms after they are written to the cache", (Object)expiryTime.toMillis());
            return builder.expireAfterWrite(expiryTime.toMillis(), TimeUnit.MILLISECONDS);
        });
    }

    public static CacheConfig initialCapacity(int initCapacity) {
        return CacheConfig.onCacheBuilder(builder -> {
            LOG.info("Initial capacity = {}", (Object)initCapacity);
            return builder.initialCapacity(initCapacity);
        });
    }

    public static CacheConfig maximumSize(long size) {
        return CacheConfig.onCacheBuilder(builder -> {
            LOG.info("Maximum size = {}", (Object)size);
            return builder.maximumSize(size);
        });
    }

    public static CacheConfig recordStats() {
        return CacheConfig.onCacheBuilder(builder -> {
            LOG.info("Recording stats");
            return builder.recordStats();
        });
    }

    static CacheConfig clockTicker(final Clock clock) {
        return CacheConfig.onCacheBuilder(builder -> {
            LOG.info("Using a {} as the clock source", (Object)clock.getClass().getName());
            return builder.ticker(new Ticker(){

                public long read() {
                    return clock.millis() * 1000000L;
                }
            });
        });
    }

    private static CacheConfig onCacheBuilder(final ConfiguresCaffeine configurer) {
        return new CacheConfig(){

            @Override
            public Caffeine<Object, Object> configure(Caffeine<Object, Object> builder) {
                return configurer.configure(builder);
            }
        };
    }

    protected CacheConfig() {
    }
}

