/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.cache2.inmemory;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import no.digipost.cache2.inmemory.Cache;
import no.digipost.cache2.inmemory.CacheConfig;
import no.digipost.cache2.loader.Callables;
import no.digipost.cache2.loader.Loader;

public final class SingleCached<V> {
    private final Cache<String, V> cache;
    private final Loader<? super String, V> resolver;
    private String key;

    public SingleCached(Callable<V> resolver, CacheConfig ... configs) {
        this(Callables.toLoader(resolver), configs);
    }

    public SingleCached(Loader<? super String, V> resolver, CacheConfig ... configs) {
        this(resolver, Arrays.asList(configs));
    }

    public SingleCached(String name, Callable<V> resolver, CacheConfig ... configs) {
        this(name, Callables.toLoader(resolver), configs);
    }

    public SingleCached(String name, Loader<? super String, V> resolver, CacheConfig ... configs) {
        this(name, resolver, Arrays.asList(configs));
    }

    public SingleCached(Callable<V> resolver, List<CacheConfig> configs) {
        this(Callables.toLoader(resolver), configs);
    }

    public SingleCached(Loader<? super String, V> resolver, List<CacheConfig> configs) {
        this("single-value-cache-" + UUID.randomUUID(), resolver, configs);
    }

    public SingleCached(String name, Callable<V> resolver, List<CacheConfig> configs) {
        this(name, Callables.toLoader(resolver), configs);
    }

    public SingleCached(String name, Loader<? super String, V> resolver, List<CacheConfig> configs) {
        this(name + "-cachekey", resolver, Cache.create(name, Stream.concat(Stream.of(CacheConfig.initialCapacity(1), CacheConfig.maximumSize(1L)), configs.stream()).collect(Collectors.toList())));
    }

    SingleCached(String cacheKey, Loader<? super String, V> resolver, Cache<String, V> underlyingCache) {
        this.cache = underlyingCache;
        this.resolver = resolver;
        this.key = cacheKey;
    }

    public V get() {
        return this.cache.get(this.key, this.resolver);
    }

    public void invalidate() {
        this.cache.invalidateAll();
    }
}

