/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.sanitizing;

import no.digipost.sanitizing.exception.HTMLValidationException;
import no.digipost.sanitizing.exception.ValidationException;
import no.digipost.sanitizing.internal.ErrorCollectingHtmlChangeListener;
import no.digipost.sanitizing.internal.PolicyFactoryProvider;
import org.owasp.html.HtmlChangeListener;
import org.owasp.html.PolicyFactory;

public class DigipostValidatingHtmlSanitizer {
    public static void main(String[] args) {
        String sanitize = new DigipostValidatingHtmlSanitizer().sanitize(args[0], PolicyFactoryProvider.getPolicyFactory());
        System.out.println(sanitize);
    }

    public String sanitize(String html, PolicyFactory policy) throws ValidationException {
        ErrorCollectingHtmlChangeListener errorCollector = PolicyFactoryProvider.errorCollector();
        String doctype = "<!doctype html>";
        if (!html.trim().toLowerCase().startsWith(doctype)) {
            doctype = "";
        }
        String sanitizedHtml = doctype + policy.sanitize(html, (HtmlChangeListener)errorCollector, null);
        if (errorCollector.hasErrors()) {
            throw new HTMLValidationException(errorCollector.getErrors());
        }
        return sanitizedHtml;
    }
}

