/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.sanitizing;

import java.util.Collections;
import java.util.List;
import no.digipost.sanitizing.exception.ValidationException;

public class HtmlValidationResult {
    public static final HtmlValidationResult HTML_EVERYTHING_OK = new HtmlValidationResult(true, false);
    public final boolean okForWeb;
    public final boolean hasDiffAfterSanitizing;
    private final List<String> validationErrors;
    private final String output;

    public HtmlValidationResult(boolean okForWeb, boolean hasDiffAfterSanitizing) {
        this.okForWeb = okForWeb;
        this.hasDiffAfterSanitizing = hasDiffAfterSanitizing;
        this.validationErrors = Collections.emptyList();
        this.output = "";
    }

    public HtmlValidationResult(ValidationException e) {
        this.okForWeb = false;
        this.hasDiffAfterSanitizing = false;
        this.validationErrors = e.getValidationErrors();
        this.output = "";
    }

    public HtmlValidationResult(String output) {
        this.output = output;
        this.okForWeb = true;
        this.validationErrors = Collections.emptyList();
        this.hasDiffAfterSanitizing = true;
    }

    public String toString() {
        return "[ " + this.getClass().getSimpleName() + (this.okForWeb ? " OK for web" : "") + "\n" + String.join((CharSequence)", ", this.validationErrors) + String.join((CharSequence)"\n", this.output) + "]";
    }
}

