/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.sanitizing;

import java.nio.charset.StandardCharsets;
import java.time.Clock;
import no.digipost.sanitizing.DigipostValidatingHtmlSanitizer;
import no.digipost.sanitizing.HtmlValidationResult;
import no.digipost.sanitizing.exception.ValidationException;
import no.digipost.sanitizing.internal.PolicyFactoryProvider;

public class HtmlValidator {
    private DigipostValidatingHtmlSanitizer digipostValidatingHtmlSanitizer;
    private Clock clock;

    public HtmlValidator() {
        this(Clock.systemDefaultZone());
    }

    public HtmlValidator(Clock clock) {
        this.clock = clock;
        this.digipostValidatingHtmlSanitizer = new DigipostValidatingHtmlSanitizer();
    }

    public HtmlValidationResult valider(byte[] content) {
        try {
            String input = new String(content, StandardCharsets.UTF_8);
            String output = this.digipostValidatingHtmlSanitizer.sanitize(input, PolicyFactoryProvider.getPolicyFactory(this.clock.instant()));
            if (input.equals(output)) {
                return HtmlValidationResult.HTML_EVERYTHING_OK;
            }
            return new HtmlValidationResult(output);
        }
        catch (ValidationException e) {
            return new HtmlValidationResult(e);
        }
    }
}

