/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.sanitizing.internal;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import no.digipost.sanitizing.internal.StyleElementPreprocessor;
import no.digipost.sanitizing.internal.ValidatorPatterns;
import org.owasp.html.AttributePolicy;
import org.owasp.html.CssSchema;
import org.owasp.html.ElementPolicy;
import org.owasp.html.HtmlPolicyBuilder;
import org.owasp.html.HtmlStreamEventProcessor;
import org.owasp.html.PolicyFactory;

final class ApiHtmlValidatorPolicy {
    private static final Set<String> CSS_WHITELIST;
    static final Map<String, Predicate<String>> CSS_PROPERTY_WHITELIST;
    private static final String[] KITH_TAGS;
    static final PolicyFactory V1_VALIDATE_ONLY_HTML_POLICY;
    static final PolicyFactory V2_VALIDATE_HTML_AND_CSS_POLICY;

    ApiHtmlValidatorPolicy() {
    }

    private static AttributePolicy value(String mustHaveValue) {
        return (elementName, attributeName, value) -> {
            if (value.equals(mustHaveValue)) {
                return value;
            }
            return null;
        };
    }

    private static AttributePolicy oneOf(Pattern ... patterns) {
        return (elementName, attributeName, value) -> {
            Optional<Pattern> match = Arrays.stream(patterns).filter(pattern -> pattern.matcher(value).matches()).findFirst();
            return match.isPresent() ? value : null;
        };
    }

    private static ElementPolicy addingAttributeIfMissing(String attribute, String value) {
        return (elementName, attributes) -> {
            int indexOfAttribute = attributes.indexOf(attribute);
            if (indexOfAttribute == -1) {
                attributes.add(attribute);
                attributes.add(value);
            }
            return elementName;
        };
    }

    static {
        KITH_TAGS = new String[]{"abbr", "acronym", "address", "dfn", "kbd", "q", "var", "tt", "caption"};
        HashSet defaultProperties = new HashSet(CssSchema.DEFAULT.allowedProperties());
        defaultProperties.addAll(Lists.newArrayList((Object[])new String[]{"top", "bottom", "left", "right", "background", "page-break-before", "page-break-after", "page-break-inside"}));
        CSS_WHITELIST = Collections.unmodifiableSet(defaultProperties);
        Predicate<String> allowAllValuesPredicate = value -> true;
        Map<String, Predicate> propertyValueWhitelist = CSS_WHITELIST.stream().collect(Collectors.toMap(prop -> prop, prop -> allowAllValuesPredicate));
        propertyValueWhitelist.put("clear", allowAllValuesPredicate);
        propertyValueWhitelist.put("float", allowAllValuesPredicate);
        propertyValueWhitelist.put("display", value -> value.equals("block") || value.equals("inline-block") || value.equals("inline"));
        propertyValueWhitelist.put("content", allowAllValuesPredicate);
        CSS_PROPERTY_WHITELIST = Collections.unmodifiableMap(propertyValueWhitelist);
        V1_VALIDATE_ONLY_HTML_POLICY = new HtmlPolicyBuilder().allowStyling(CssSchema.withProperties(CSS_WHITELIST)).allowUrlsInStyles(AttributePolicy.IDENTITY_ATTRIBUTE_POLICY).allowStandardUrlProtocols().allowUrlProtocols(new String[]{"data"}).allowAttributes(new String[]{"id"}).matching(ValidatorPatterns.HTML_ID).globally().allowAttributes(new String[]{"class"}).matching(ValidatorPatterns.HTML_CLASS).globally().allowAttributes(new String[]{"lang"}).matching(Pattern.compile("[a-zA-Z]{2,20}")).globally().allowAttributes(new String[]{"title"}).matching(ValidatorPatterns.HTML_TITLE).globally().allowAttributes(new String[]{"align"}).matching(ValidatorPatterns.ALIGN).onElements(new String[]{"p"}).allowAttributes(new String[]{"for"}).matching(ValidatorPatterns.HTML_ID).onElements(new String[]{"label"}).allowAttributes(new String[]{"color"}).matching(ValidatorPatterns.COLOR_NAME_OR_COLOR_CODE::test).onElements(new String[]{"font"}).allowAttributes(new String[]{"face"}).matching(Pattern.compile("[\\w;, \\-]+")).onElements(new String[]{"font"}).allowAttributes(new String[]{"size"}).matching(ValidatorPatterns.NUMBER).onElements(new String[]{"font"}).allowElements(ApiHtmlValidatorPolicy.addingAttributeIfMissing("target", "_blank"), new String[]{"a"}).allowAttributes(new String[]{"target"}).matching(ApiHtmlValidatorPolicy.value("_blank")).onElements(new String[]{"a"}).allowAttributes(new String[]{"href"}).matching(ValidatorPatterns.ONSITE_OR_OFFSITE_URL::test).onElements(new String[]{"a"}).allowAttributes(new String[]{"nohref"}).onElements(new String[]{"a"}).allowAttributes(new String[]{"name"}).matching(ValidatorPatterns.NAME).onElements(new String[]{"a"}).requireRelNofollowOnLinks().requireRelsOnLinks(new String[]{"noreferrer", "noopener"}).allowAttributes(new String[]{"src"}).matching(ValidatorPatterns.IMAGE_DATA_URL).onElements(new String[]{"img"}).allowAttributes(new String[]{"alt"}).onElements(new String[]{"img"}).allowAttributes(new String[]{"border", "cellpadding", "cellspacing"}).matching(ValidatorPatterns.NUMBER).onElements(new String[]{"table"}).allowAttributes(new String[]{"bgcolor"}).matching(ValidatorPatterns.COLOR_NAME_OR_COLOR_CODE::test).onElements(new String[]{"table"}).allowAttributes(new String[]{"background"}).matching(ValidatorPatterns.ONSITE_URL).onElements(new String[]{"table"}).allowAttributes(new String[]{"align"}).matching(ValidatorPatterns.ALIGN).onElements(new String[]{"table"}).allowAttributes(new String[]{"noresize"}).matching(Pattern.compile("(?i)noresize")).onElements(new String[]{"table"}).allowAttributes(new String[]{"background"}).matching(ValidatorPatterns.ONSITE_URL).onElements(new String[]{"td", "th", "tr"}).allowAttributes(new String[]{"bgcolor"}).matching(ValidatorPatterns.COLOR_NAME_OR_COLOR_CODE::test).onElements(new String[]{"td", "th"}).allowAttributes(new String[]{"abbr"}).matching(ValidatorPatterns.PARAGRAPH).onElements(new String[]{"td", "th"}).allowAttributes(new String[]{"axis", "headers"}).matching(ValidatorPatterns.NAME).onElements(new String[]{"td", "th"}).allowAttributes(new String[]{"scope"}).matching(Pattern.compile("(?i)(?:row|col)(?:group)?")).onElements(new String[]{"td", "th"}).allowAttributes(new String[]{"nowrap"}).onElements(new String[]{"td", "th"}).allowAttributes(new String[]{"height", "width"}).matching(ValidatorPatterns.NUMBER_OR_PERCENT).onElements(new String[]{"table", "td", "th", "tr", "img", "hr"}).allowAttributes(new String[]{"align"}).matching(ValidatorPatterns.ALIGN).onElements(new String[]{"thead", "tbody", "tfoot", "img", "td", "th", "tr", "colgroup", "col", "hr"}).allowAttributes(new String[]{"valign"}).matching(ValidatorPatterns.VALIGN).onElements(new String[]{"thead", "tbody", "tfoot", "td", "th", "tr", "colgroup", "col"}).allowAttributes(new String[]{"charoff"}).matching(ValidatorPatterns.NUMBER_OR_PERCENT).onElements(new String[]{"td", "th", "tr", "colgroup", "col", "thead", "tbody", "tfoot"}).allowAttributes(new String[]{"char"}).matching(ValidatorPatterns.ONE_CHAR).onElements(new String[]{"td", "th", "tr", "colgroup", "col", "thead", "tbody", "tfoot"}).allowAttributes(new String[]{"colspan", "rowspan"}).matching(ValidatorPatterns.NUMBER).onElements(new String[]{"td", "th"}).allowAttributes(new String[]{"span", "width"}).matching(ValidatorPatterns.NUMBER_OR_PERCENT).onElements(new String[]{"colgroup", "col"}).allowAttributes(new String[]{"type"}).matching(ValidatorPatterns.CSS_TYPE).onElements(new String[]{"style"}).allowAttributes(new String[]{"target"}).matching(ValidatorPatterns.TARGET_BLANK).onElements(new String[]{"base"}).allowAttributes(new String[]{"http-equiv"}).matching(true, new String[]{"content-type"}).onElements(new String[]{"meta"}).allowAttributes(new String[]{"charset"}).onElements(new String[]{"meta"}).allowAttributes(new String[]{"name"}).matching(true, new String[]{"viewport"}).onElements(new String[]{"meta"}).allowAttributes(new String[]{"content"}).matching(ApiHtmlValidatorPolicy.oneOf(ValidatorPatterns.META_VIEWPORT_VALUES, ValidatorPatterns.TYPE_AND_CHARSET)).onElements(new String[]{"meta"}).allowElements(KITH_TAGS).allowElements(new String[]{"html", "body", "head", "title", "meta", "base", "style", "a", "label", "noscript", "h1", "h2", "h3", "h4", "h5", "h6", "p", "i", "b", "u", "strong", "em", "small", "big", "pre", "code", "cite", "samp", "sub", "sup", "strike", "center", "blockquote", "hr", "br", "col", "font", "map", "span", "div", "img", "ul", "ol", "li", "dd", "dt", "dl", "tbody", "thead", "tfoot", "table", "td", "th", "tr", "colgroup", "fieldset", "legend", "figure", "figcaption", "header", "nav", "section", "aside", "article", "footer", "hgroup", "main"}).allowWithoutAttributes(new String[]{"span"}).toFactory();
        V2_VALIDATE_HTML_AND_CSS_POLICY = V1_VALIDATE_ONLY_HTML_POLICY.and(new HtmlPolicyBuilder().allowTextIn(new String[]{"style"}).withPreprocessor((HtmlStreamEventProcessor)new StyleElementPreprocessor()).toFactory());
    }
}

