/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.sanitizing.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.owasp.html.HtmlChangeListener;

public final class ErrorCollectingHtmlChangeListener
implements HtmlChangeListener<List<String>> {
    private final List<String> errorCollector = new ArrayList<String>();

    ErrorCollectingHtmlChangeListener() {
    }

    public void discardedTag(List<String> context, String elementName) {
        this.errorCollector.add("Found HTML policy violation. Tag name: " + elementName);
    }

    public void discardedAttributes(List<String> context, String tagName, String ... attributeNames) {
        String illegalAttributes = Arrays.stream(attributeNames).collect(Collectors.joining(", "));
        this.errorCollector.add("Found HTML policy violation: Tag name: " + tagName + ", attribute(s): " + illegalAttributes);
    }

    public boolean hasErrors() {
        return !this.errorCollector.isEmpty();
    }

    public int getNumberOfErrors() {
        return this.errorCollector.size();
    }

    public List<String> getErrors() {
        return this.errorCollector;
    }
}

