/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.sanitizing.internal;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import no.digipost.sanitizing.internal.ApiHtmlValidatorPolicy;
import no.digipost.sanitizing.internal.ErrorCollectingHtmlChangeListener;
import org.owasp.html.PolicyFactory;

public final class PolicyFactoryProvider {
    public static final Instant V2_IN_EFFECT = ZonedDateTime.of(2019, 6, 4, 7, 10, 0, 0, ZoneOffset.UTC).toInstant();

    public static PolicyFactory getPolicyFactory() {
        return PolicyFactoryProvider.getPolicyFactory(Instant.now());
    }

    public static PolicyFactory getPolicyFactory(Instant documentCreationDate) {
        if (documentCreationDate.isBefore(V2_IN_EFFECT)) {
            return ApiHtmlValidatorPolicy.V1_VALIDATE_ONLY_HTML_POLICY;
        }
        return ApiHtmlValidatorPolicy.V2_VALIDATE_HTML_AND_CSS_POLICY;
    }

    public static ErrorCollectingHtmlChangeListener errorCollector() {
        return new ErrorCollectingHtmlChangeListener();
    }
}

