/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.datatypes;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import no.digipost.api.datatypes.ComplementedBy;
import no.digipost.api.datatypes.DataType;
import no.digipost.api.datatypes.types.Appointment;
import no.digipost.api.datatypes.types.Boligdetaljer;
import no.digipost.api.datatypes.types.Event;
import no.digipost.api.datatypes.types.ExternalLink;
import no.digipost.api.datatypes.types.Inkasso;
import no.digipost.api.datatypes.types.Payslip;
import no.digipost.api.datatypes.types.Residence;
import no.digipost.api.datatypes.types.SignedDocument;
import no.digipost.api.datatypes.types.pickup.PickupNotice;
import no.digipost.api.datatypes.types.pickup.PickupNoticeStatus;
import no.digipost.api.datatypes.types.proof.Proof;
import no.digipost.api.datatypes.types.receipt.Receipt;

public enum DataTypeIdentifier {
    APPOINTMENT(Appointment.class, "APPT", Appointment.EXAMPLE),
    RESIDENCE(Residence.class, "RESD", Residence.EXAMPLE),
    EXTERNAL_LINK(ExternalLink.class, "EXTL", ExternalLink.EXAMPLE),
    BOLIGDETALJER(Boligdetaljer.class, "RDTL", Boligdetaljer.EXAMPLE),
    RECEIPT(Receipt.class, "RCPT", Receipt.EXAMPLE),
    PAYSLIP(Payslip.class, "PAY", Payslip.EXAMPLE),
    SIGNED_DOCUMENT(SignedDocument.class, "SIGN", SignedDocument.EXAMPLE),
    PICKUP_NOTICE(PickupNotice.class, "PKUP", PickupNotice.EXAMPLE),
    PICKUP_NOTICE_STATUS(PickupNoticeStatus.class, "PKUS", PickupNoticeStatus.EXAMPLE),
    EVENT(Event.class, "EVNT", Event.EXAMPLE),
    PROOF(Proof.class, "PRF", Proof.EXAMPLE),
    INKASSO(Inkasso.class, "INKA", Inkasso.EXAMPLE);

    private final Class<? extends DataType> dataType;
    private final String shortName;
    private final DataType example;
    private static final Map<Class<? extends DataType>, DataTypeIdentifier> byType;
    private static final Map<String, DataTypeIdentifier> byShortName;
    private final Set<Class<? extends DataType>> complementables;

    private DataTypeIdentifier(Class<? extends DataType> dataType, String shortName, DataType example) {
        this.dataType = dataType;
        this.shortName = shortName;
        this.example = example;
        this.complementables = Optional.ofNullable(this.getDataType().getAnnotation(ComplementedBy.class)).map(ComplementedBy::value).map(Stream::of).orElseGet(Stream::empty).collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
    }

    public Class<? extends DataType> getDataType() {
        return this.dataType;
    }

    public String getShortName() {
        return this.shortName;
    }

    public static DataTypeIdentifier fromRepresentationType(Class<? extends DataType> representation) {
        return Optional.ofNullable(byType.get(representation)).orElseThrow(() -> new IllegalStateException(String.format("Could not find %s for type %s. All subtypes of %s must have a unique %s.", DataTypeIdentifier.class.getSimpleName(), representation, DataType.class.getSimpleName(), DataTypeIdentifier.class.getSimpleName())));
    }

    public static DataTypeIdentifier fromShortName(String shortName) {
        return Optional.ofNullable(byShortName.get(shortName)).orElseThrow(() -> new IllegalArgumentException("No value for " + DataTypeIdentifier.class.getSimpleName() + " found for shortName " + shortName));
    }

    public DataType getExample() {
        return this.example;
    }

    public static Set<Class<? extends DataType>> getAllClasses() {
        return byType.keySet();
    }

    public boolean canBeComplementedBy(DataType successor) {
        return this.complementables.contains(successor.getClass());
    }

    static {
        byType = Stream.of(DataTypeIdentifier.values()).collect(Collectors.toMap(DataTypeIdentifier::getDataType, Function.identity()));
        byShortName = Stream.of(DataTypeIdentifier.values()).collect(Collectors.toMap(DataTypeIdentifier::getShortName, Function.identity()));
    }
}

