/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.datatypes.documentation;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlElement;
import no.digipost.api.datatypes.ComplementedBy;
import no.digipost.api.datatypes.documentation.ComplexType;
import no.digipost.api.datatypes.documentation.DataTypePackage;
import no.digipost.api.datatypes.documentation.Description;
import no.digipost.api.datatypes.documentation.FieldInfo;
import no.digipost.api.datatypes.documentation.FieldType;
import no.digipost.api.datatypes.documentation.SimpleType;

public class DocumentationStructureBuilder {
    public static <T> Stream<ComplexType> buildTypeStructure(Set<Class<? extends T>> classes, Function<Class<? extends T>, T> getExample) {
        return classes.stream().map(DocumentationStructureBuilder.getTypeInfoWithExample(getExample)).sorted();
    }

    private static <T> Function<? super Class<? extends T>, ComplexType> getTypeInfoWithExample(Function<Class<? extends T>, T> getExample) {
        return type -> new ComplexType((Class<?>)type, DocumentationStructureBuilder.getDescription(type), DocumentationStructureBuilder.getFieldInfos(type), getExample.apply((Class)type), DocumentationStructureBuilder.getComplementables(type));
    }

    private static List<ComplexType> getComplementables(Class<?> dataType) {
        return Optional.ofNullable(dataType.getAnnotation(ComplementedBy.class)).map(ComplementedBy::value).map(Stream::of).orElseGet(Stream::empty).map(c -> new ComplexType((Class<?>)c, null, null, null, Collections.emptyList())).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    private static List<FieldInfo> getFieldInfos(Class<?> dataType) {
        return Stream.of(dataType.getDeclaredFields()).filter(f -> !Modifier.isStatic(f.getModifiers())).map(DocumentationStructureBuilder.getFieldInfo()).collect(Collectors.toList());
    }

    private static Function<Field, FieldInfo> getFieldInfo() {
        return field -> new FieldInfo(field.getName(), DocumentationStructureBuilder.resolveTypeOfField(field.getType()), DocumentationStructureBuilder.isMandatory(field), DocumentationStructureBuilder.getDescription(field));
    }

    private static String getDescription(AnnotatedElement element) {
        return Stream.of((Description[])element.getAnnotationsByType(Description.class)).map(Description::value).collect(Collectors.joining(System.lineSeparator()));
    }

    private static boolean isMandatory(Field field) {
        boolean requiredXmlElement = Stream.of((XmlElement[])field.getAnnotationsByType(XmlElement.class)).anyMatch(XmlElement::required);
        boolean notNull = ((NotNull[])field.getAnnotationsByType(NotNull.class)).length > 0;
        return requiredXmlElement || notNull;
    }

    private static FieldType resolveTypeOfField(Class<?> fieldType) {
        if (fieldType.getPackage().isAnnotationPresent(DataTypePackage.class)) {
            return new ComplexType(fieldType, DocumentationStructureBuilder.getDescription(fieldType), DocumentationStructureBuilder.getFieldInfos(fieldType), null, Collections.emptyList());
        }
        return new SimpleType(fieldType);
    }
}

