/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.datatypes.marshalling;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public class ZonedDateTimeXmlAdapter
extends XmlAdapter<String, ZonedDateTime> {
    public String marshal(ZonedDateTime v) {
        if (v == null) {
            return null;
        }
        return DatatypeConverter.printDateTime((Calendar)GregorianCalendar.from(v));
    }

    public ZonedDateTime unmarshal(String s) {
        if (s == null) {
            return null;
        }
        TemporalAccessor parsed = DateTimeFormatter.ISO_DATE_TIME.parse(s);
        if (parsed.isSupported(ChronoField.OFFSET_SECONDS)) {
            return ZonedDateTime.from(parsed);
        }
        return LocalDateTime.from(parsed).atZone(ZoneOffset.UTC);
    }
}

