/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.datatypes.types;

import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import no.digipost.api.datatypes.documentation.Description;

@XmlType
public final class Address {
    @XmlElement(name="street-address")
    @Size(max=100)
    @Description(value="E.g. Storgata 11")
    private final @Size(max=100) String streetAddress;
    @XmlElement(name="street-address-2")
    @Size(max=100)
    @Description(value="E.g. Romerike N\u00e6ringspark")
    private final @Size(max=100) String streetAddress2;
    @XmlElement(name="postal-code")
    @Size(max=10)
    private final @Size(max=10) String postalCode;
    @XmlElement
    @Size(max=100)
    private final @Size(max=100) String city;
    @XmlElement
    private final String country;
    public static final Address EXAMPLE = new Address("Storgata 23", null, "0011", "Oslo", "Norge");

    public String getStreetAddress() {
        return this.streetAddress;
    }

    public String getStreetAddress2() {
        return this.streetAddress2;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public String getCity() {
        return this.city;
    }

    public String getCountry() {
        return this.country;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Address)) {
            return false;
        }
        Address other = (Address)o;
        String this$streetAddress = this.getStreetAddress();
        String other$streetAddress = other.getStreetAddress();
        if (this$streetAddress == null ? other$streetAddress != null : !this$streetAddress.equals(other$streetAddress)) {
            return false;
        }
        String this$streetAddress2 = this.getStreetAddress2();
        String other$streetAddress2 = other.getStreetAddress2();
        if (this$streetAddress2 == null ? other$streetAddress2 != null : !this$streetAddress2.equals(other$streetAddress2)) {
            return false;
        }
        String this$postalCode = this.getPostalCode();
        String other$postalCode = other.getPostalCode();
        if (this$postalCode == null ? other$postalCode != null : !this$postalCode.equals(other$postalCode)) {
            return false;
        }
        String this$city = this.getCity();
        String other$city = other.getCity();
        if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
            return false;
        }
        String this$country = this.getCountry();
        String other$country = other.getCountry();
        return !(this$country == null ? other$country != null : !this$country.equals(other$country));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $streetAddress = this.getStreetAddress();
        result = result * 59 + ($streetAddress == null ? 43 : $streetAddress.hashCode());
        String $streetAddress2 = this.getStreetAddress2();
        result = result * 59 + ($streetAddress2 == null ? 43 : $streetAddress2.hashCode());
        String $postalCode = this.getPostalCode();
        result = result * 59 + ($postalCode == null ? 43 : $postalCode.hashCode());
        String $city = this.getCity();
        result = result * 59 + ($city == null ? 43 : $city.hashCode());
        String $country = this.getCountry();
        result = result * 59 + ($country == null ? 43 : $country.hashCode());
        return result;
    }

    public String toString() {
        return "Address(streetAddress=" + this.getStreetAddress() + ", streetAddress2=" + this.getStreetAddress2() + ", postalCode=" + this.getPostalCode() + ", city=" + this.getCity() + ", country=" + this.getCountry() + ")";
    }

    public Address(String streetAddress, String streetAddress2, String postalCode, String city, String country) {
        this.streetAddress = streetAddress;
        this.streetAddress2 = streetAddress2;
        this.postalCode = postalCode;
        this.city = city;
        this.country = country;
    }

    private Address() {
        this.streetAddress = null;
        this.streetAddress2 = null;
        this.postalCode = null;
        this.city = null;
        this.country = null;
    }

    public Address withStreetAddress(String streetAddress) {
        return this.streetAddress == streetAddress ? this : new Address(streetAddress, this.streetAddress2, this.postalCode, this.city, this.country);
    }

    public Address withStreetAddress2(String streetAddress2) {
        return this.streetAddress2 == streetAddress2 ? this : new Address(this.streetAddress, streetAddress2, this.postalCode, this.city, this.country);
    }

    public Address withPostalCode(String postalCode) {
        return this.postalCode == postalCode ? this : new Address(this.streetAddress, this.streetAddress2, postalCode, this.city, this.country);
    }

    public Address withCity(String city) {
        return this.city == city ? this : new Address(this.streetAddress, this.streetAddress2, this.postalCode, city, this.country);
    }

    public Address withCountry(String country) {
        return this.country == country ? this : new Address(this.streetAddress, this.streetAddress2, this.postalCode, this.city, country);
    }
}

