/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.datatypes.types;

import java.net.URI;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import no.digipost.api.datatypes.DataType;
import no.digipost.api.datatypes.documentation.Description;
import no.digipost.api.datatypes.validation.WebUrl;

@XmlRootElement
@Description(value="An external URL, along with an optional description and deadline for resources such as a survey.")
public final class ExternalLink
implements DataType {
    @XmlElement(required=true)
    @XmlSchemaType(name="anyURI")
    @NotNull
    @WebUrl
    @Description(value="Target URL of this link. Must be http or https.")
    private final URI url;
    @XmlElement
    @XmlSchemaType(name="dateTime")
    @Description(value="Optional deadline for the user to respond. ISO8601 full DateTime.")
    private final ZonedDateTime deadline;
    @XmlElement
    @Size(max=140)
    @Description(value="A short, optional text-field, describing the external link.")
    private final @Size(max=140) String description;
    @XmlElement(name="button-text")
    @Size(max=30)
    @Description(value="Optional text which will be displayed on the button.")
    private final @Size(max=30) String buttonText;
    public static ExternalLink EXAMPLE = new ExternalLink(URI.create("https://www.oslo.kommune.no/barnehage/svar-pa-tilbud-om-plass/"), ZonedDateTime.of(2017, 9, 30, 13, 37, 0, 0, ZoneId.of("+02:00")), "Oslo Kommune ber deg akseptere eller avsl\u00e5 tilbudet om barnehageplass.", "Svar p\u00e5 barnehageplass");
    public static ExternalLink EXAMPLE_NO_DEADLINE = new ExternalLink(URI.create("https://www.example.com"), null, "G\u00e5 til avsenders side for \u00e5 gj\u00f8re en handling", "Ta meg til handling!");

    public ExternalLink(URI url) {
        this(url, null, null, null);
    }

    public URI getUrl() {
        return this.url;
    }

    public ZonedDateTime getDeadline() {
        return this.deadline;
    }

    public String getDescription() {
        return this.description;
    }

    public String getButtonText() {
        return this.buttonText;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExternalLink)) {
            return false;
        }
        ExternalLink other = (ExternalLink)o;
        URI this$url = this.getUrl();
        URI other$url = other.getUrl();
        if (this$url == null ? other$url != null : !((Object)this$url).equals(other$url)) {
            return false;
        }
        ZonedDateTime this$deadline = this.getDeadline();
        ZonedDateTime other$deadline = other.getDeadline();
        if (this$deadline == null ? other$deadline != null : !((Object)this$deadline).equals(other$deadline)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$buttonText = this.getButtonText();
        String other$buttonText = other.getButtonText();
        return !(this$buttonText == null ? other$buttonText != null : !this$buttonText.equals(other$buttonText));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        URI $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : ((Object)$url).hashCode());
        ZonedDateTime $deadline = this.getDeadline();
        result = result * 59 + ($deadline == null ? 43 : ((Object)$deadline).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $buttonText = this.getButtonText();
        result = result * 59 + ($buttonText == null ? 43 : $buttonText.hashCode());
        return result;
    }

    public String toString() {
        return "ExternalLink(url=" + this.getUrl() + ", deadline=" + this.getDeadline() + ", description=" + this.getDescription() + ", buttonText=" + this.getButtonText() + ")";
    }

    public ExternalLink withUrl(URI url) {
        return this.url == url ? this : new ExternalLink(url, this.deadline, this.description, this.buttonText);
    }

    public ExternalLink withDeadline(ZonedDateTime deadline) {
        return this.deadline == deadline ? this : new ExternalLink(this.url, deadline, this.description, this.buttonText);
    }

    public ExternalLink withDescription(String description) {
        return this.description == description ? this : new ExternalLink(this.url, this.deadline, description, this.buttonText);
    }

    public ExternalLink withButtonText(String buttonText) {
        return this.buttonText == buttonText ? this : new ExternalLink(this.url, this.deadline, this.description, buttonText);
    }

    public ExternalLink(URI url, ZonedDateTime deadline, String description, String buttonText) {
        this.url = url;
        this.deadline = deadline;
        this.description = description;
        this.buttonText = buttonText;
    }

    private ExternalLink() {
        this.url = null;
        this.deadline = null;
        this.description = null;
        this.buttonText = null;
    }
}

