/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.datatypes.types;

import java.math.BigDecimal;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import no.digipost.api.datatypes.documentation.Description;

@XmlType
@Description(value="Payment in foreign currency with conversion")
public final class ForeignCurrencyPayment {
    @XmlElement(name="currency-code")
    @Size(max=3)
    @Description(value="Currency of the payment, ISO4217. Example: NOK")
    private final @Size(max=3) String currencyCode;
    @XmlElement(name="amount")
    private final BigDecimal amount;
    @XmlElement(name="exchange-rate")
    private final BigDecimal exchangeRate;
    @XmlElement(name="label")
    private final String label;
    public static ForeignCurrencyPayment EXAMPLE = new ForeignCurrencyPayment("USD", new BigDecimal("15"), new BigDecimal("7.534567"), null);

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public BigDecimal getExchangeRate() {
        return this.exchangeRate;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ForeignCurrencyPayment)) {
            return false;
        }
        ForeignCurrencyPayment other = (ForeignCurrencyPayment)o;
        String this$currencyCode = this.getCurrencyCode();
        String other$currencyCode = other.getCurrencyCode();
        if (this$currencyCode == null ? other$currencyCode != null : !this$currencyCode.equals(other$currencyCode)) {
            return false;
        }
        BigDecimal this$amount = this.getAmount();
        BigDecimal other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        BigDecimal this$exchangeRate = this.getExchangeRate();
        BigDecimal other$exchangeRate = other.getExchangeRate();
        if (this$exchangeRate == null ? other$exchangeRate != null : !((Object)this$exchangeRate).equals(other$exchangeRate)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        return !(this$label == null ? other$label != null : !this$label.equals(other$label));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $currencyCode = this.getCurrencyCode();
        result = result * 59 + ($currencyCode == null ? 43 : $currencyCode.hashCode());
        BigDecimal $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        BigDecimal $exchangeRate = this.getExchangeRate();
        result = result * 59 + ($exchangeRate == null ? 43 : ((Object)$exchangeRate).hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        return result;
    }

    public String toString() {
        return "ForeignCurrencyPayment(currencyCode=" + this.getCurrencyCode() + ", amount=" + this.getAmount() + ", exchangeRate=" + this.getExchangeRate() + ", label=" + this.getLabel() + ")";
    }

    public ForeignCurrencyPayment(String currencyCode, BigDecimal amount, BigDecimal exchangeRate, String label) {
        this.currencyCode = currencyCode;
        this.amount = amount;
        this.exchangeRate = exchangeRate;
        this.label = label;
    }

    private ForeignCurrencyPayment() {
        this.currencyCode = null;
        this.amount = null;
        this.exchangeRate = null;
        this.label = null;
    }

    public ForeignCurrencyPayment withCurrencyCode(String currencyCode) {
        return this.currencyCode == currencyCode ? this : new ForeignCurrencyPayment(currencyCode, this.amount, this.exchangeRate, this.label);
    }

    public ForeignCurrencyPayment withAmount(BigDecimal amount) {
        return this.amount == amount ? this : new ForeignCurrencyPayment(this.currencyCode, amount, this.exchangeRate, this.label);
    }

    public ForeignCurrencyPayment withExchangeRate(BigDecimal exchangeRate) {
        return this.exchangeRate == exchangeRate ? this : new ForeignCurrencyPayment(this.currencyCode, this.amount, exchangeRate, this.label);
    }

    public ForeignCurrencyPayment withLabel(String label) {
        return this.label == label ? this : new ForeignCurrencyPayment(this.currencyCode, this.amount, this.exchangeRate, label);
    }
}

