/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.datatypes.types;

import java.math.BigDecimal;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import no.digipost.api.datatypes.DataType;
import no.digipost.api.datatypes.documentation.Description;
import no.digipost.api.datatypes.types.ExternalLink;

@XmlRootElement
@Description(value="A debt collection payment")
public final class Inkasso
implements DataType {
    @XmlElement
    @Description(value="A link to more information, or further actions that can be taken")
    private final ExternalLink link;
    @XmlElement(required=true, name="due-date")
    @Description(value="When the payment falls due")
    private final ZonedDateTime dueDate;
    @XmlElement
    @Description(value="The sum to be payed")
    private final BigDecimal sum;
    @XmlElement
    @Description(value="The creditor account for the payment. Exactly 11 digits")
    @Size(min=11, max=11)
    private final @Size(min=11, max=11) String account;
    @XmlElement
    @Description(value="The customer identification number. Max length 25 chars")
    @Size(max=25)
    private final @Size(max=25) String kid;
    public static Inkasso EXAMPLE = new Inkasso(ExternalLink.EXAMPLE_NO_DEADLINE, ZonedDateTime.of(2019, 12, 10, 0, 0, 0, 0, ZoneId.of("+01:00")), BigDecimal.valueOf(42L), "01235424320", "1435025439583420243982723");

    public ExternalLink getLink() {
        return this.link;
    }

    public ZonedDateTime getDueDate() {
        return this.dueDate;
    }

    public BigDecimal getSum() {
        return this.sum;
    }

    public String getAccount() {
        return this.account;
    }

    public String getKid() {
        return this.kid;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Inkasso)) {
            return false;
        }
        Inkasso other = (Inkasso)o;
        ExternalLink this$link = this.getLink();
        ExternalLink other$link = other.getLink();
        if (this$link == null ? other$link != null : !((Object)this$link).equals(other$link)) {
            return false;
        }
        ZonedDateTime this$dueDate = this.getDueDate();
        ZonedDateTime other$dueDate = other.getDueDate();
        if (this$dueDate == null ? other$dueDate != null : !((Object)this$dueDate).equals(other$dueDate)) {
            return false;
        }
        BigDecimal this$sum = this.getSum();
        BigDecimal other$sum = other.getSum();
        if (this$sum == null ? other$sum != null : !((Object)this$sum).equals(other$sum)) {
            return false;
        }
        String this$account = this.getAccount();
        String other$account = other.getAccount();
        if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
            return false;
        }
        String this$kid = this.getKid();
        String other$kid = other.getKid();
        return !(this$kid == null ? other$kid != null : !this$kid.equals(other$kid));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ExternalLink $link = this.getLink();
        result = result * 59 + ($link == null ? 43 : ((Object)$link).hashCode());
        ZonedDateTime $dueDate = this.getDueDate();
        result = result * 59 + ($dueDate == null ? 43 : ((Object)$dueDate).hashCode());
        BigDecimal $sum = this.getSum();
        result = result * 59 + ($sum == null ? 43 : ((Object)$sum).hashCode());
        String $account = this.getAccount();
        result = result * 59 + ($account == null ? 43 : $account.hashCode());
        String $kid = this.getKid();
        result = result * 59 + ($kid == null ? 43 : $kid.hashCode());
        return result;
    }

    public String toString() {
        return "Inkasso(link=" + this.getLink() + ", dueDate=" + this.getDueDate() + ", sum=" + this.getSum() + ", account=" + this.getAccount() + ", kid=" + this.getKid() + ")";
    }

    public Inkasso(ExternalLink link, ZonedDateTime dueDate, BigDecimal sum, String account, String kid) {
        this.link = link;
        this.dueDate = dueDate;
        this.sum = sum;
        this.account = account;
        this.kid = kid;
    }

    private Inkasso() {
        this.link = null;
        this.dueDate = null;
        this.sum = null;
        this.account = null;
        this.kid = null;
    }

    public Inkasso withLink(ExternalLink link) {
        return this.link == link ? this : new Inkasso(link, this.dueDate, this.sum, this.account, this.kid);
    }

    public Inkasso withDueDate(ZonedDateTime dueDate) {
        return this.dueDate == dueDate ? this : new Inkasso(this.link, dueDate, this.sum, this.account, this.kid);
    }

    public Inkasso withSum(BigDecimal sum) {
        return this.sum == sum ? this : new Inkasso(this.link, this.dueDate, sum, this.account, this.kid);
    }

    public Inkasso withAccount(String account) {
        return this.account == account ? this : new Inkasso(this.link, this.dueDate, this.sum, account, this.kid);
    }

    public Inkasso withKid(String kid) {
        return this.kid == kid ? this : new Inkasso(this.link, this.dueDate, this.sum, this.account, kid);
    }
}

