/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.datatypes.types;

import java.net.URI;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import no.digipost.api.datatypes.documentation.Description;
import no.digipost.api.datatypes.validation.WebUrl;

@XmlType
@Description(value="A link is a represention of an <a> element in html with href-url and a text. <a href='url'>description</a>")
public final class Link {
    @XmlElement(required=true)
    @XmlSchemaType(name="anyURI")
    @NotNull
    @WebUrl
    @Description(value="Target URL of this link. Must be http or https.")
    private final URI url;
    @XmlElement(required=true)
    @Size(max=70)
    @Description(value="The text-part of av an <a> html element.")
    private final @Size(max=70) String description;
    public static Link EXAMPLE = new Link(URI.create("https://valg.no"), "Les mer om valget p\u00e5 valg.no");

    public URI getUrl() {
        return this.url;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Link)) {
            return false;
        }
        Link other = (Link)o;
        URI this$url = this.getUrl();
        URI other$url = other.getUrl();
        if (this$url == null ? other$url != null : !((Object)this$url).equals(other$url)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        URI $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : ((Object)$url).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    public String toString() {
        return "Link(url=" + this.getUrl() + ", description=" + this.getDescription() + ")";
    }

    public Link(URI url, String description) {
        this.url = url;
        this.description = description;
    }

    private Link() {
        this.url = null;
        this.description = null;
    }

    public Link withUrl(URI url) {
        return this.url == url ? this : new Link(url, this.description);
    }

    public Link withDescription(String description) {
        return this.description == description ? this : new Link(this.url, description);
    }
}

