/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.datatypes.types;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlType
public final class Matrikkel {
    @XmlElement(required=true)
    @Valid
    @NotNull
    @Size(max=4)
    @Pattern(regexp="\\d+", message="can only be digits")
    private final @Valid @NotNull @Size(max=4) @Pattern(regexp="\\d+", message="can only be digits") String kommunenummer;
    @XmlElement(required=true)
    @Valid
    @NotNull
    @Size(max=4)
    @Pattern(regexp="\\d+", message="can only be digits")
    private final @Valid @NotNull @Size(max=4) @Pattern(regexp="\\d+", message="can only be digits") String gaardsnummer;
    @XmlElement(required=true)
    @Valid
    @NotNull
    @Pattern(regexp="\\d+", message="can only be digits")
    private final @Valid @NotNull @Pattern(regexp="\\d+", message="can only be digits") String bruksnummer;
    @XmlElement
    @Pattern(regexp="\\d+", message="can only be digits")
    private final @Pattern(regexp="\\d+", message="can only be digits") String festenummer;
    @XmlElement
    @Pattern(regexp="\\d+", message="can only be digits")
    private final @Pattern(regexp="\\d+", message="can only be digits") String seksjonsnummer;
    public static final Matrikkel EXAMPLE = new Matrikkel("0301", "208", "630", "0", "0");

    public Matrikkel(String kommunenummer, String gaardsnummer, String bruksnummer) {
        this(kommunenummer, gaardsnummer, bruksnummer, "0", "0");
    }

    public String getKommunenummer() {
        return this.kommunenummer;
    }

    public String getGaardsnummer() {
        return this.gaardsnummer;
    }

    public String getBruksnummer() {
        return this.bruksnummer;
    }

    public String getFestenummer() {
        return this.festenummer;
    }

    public String getSeksjonsnummer() {
        return this.seksjonsnummer;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Matrikkel)) {
            return false;
        }
        Matrikkel other = (Matrikkel)o;
        String this$kommunenummer = this.getKommunenummer();
        String other$kommunenummer = other.getKommunenummer();
        if (this$kommunenummer == null ? other$kommunenummer != null : !this$kommunenummer.equals(other$kommunenummer)) {
            return false;
        }
        String this$gaardsnummer = this.getGaardsnummer();
        String other$gaardsnummer = other.getGaardsnummer();
        if (this$gaardsnummer == null ? other$gaardsnummer != null : !this$gaardsnummer.equals(other$gaardsnummer)) {
            return false;
        }
        String this$bruksnummer = this.getBruksnummer();
        String other$bruksnummer = other.getBruksnummer();
        if (this$bruksnummer == null ? other$bruksnummer != null : !this$bruksnummer.equals(other$bruksnummer)) {
            return false;
        }
        String this$festenummer = this.getFestenummer();
        String other$festenummer = other.getFestenummer();
        if (this$festenummer == null ? other$festenummer != null : !this$festenummer.equals(other$festenummer)) {
            return false;
        }
        String this$seksjonsnummer = this.getSeksjonsnummer();
        String other$seksjonsnummer = other.getSeksjonsnummer();
        return !(this$seksjonsnummer == null ? other$seksjonsnummer != null : !this$seksjonsnummer.equals(other$seksjonsnummer));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $kommunenummer = this.getKommunenummer();
        result = result * 59 + ($kommunenummer == null ? 43 : $kommunenummer.hashCode());
        String $gaardsnummer = this.getGaardsnummer();
        result = result * 59 + ($gaardsnummer == null ? 43 : $gaardsnummer.hashCode());
        String $bruksnummer = this.getBruksnummer();
        result = result * 59 + ($bruksnummer == null ? 43 : $bruksnummer.hashCode());
        String $festenummer = this.getFestenummer();
        result = result * 59 + ($festenummer == null ? 43 : $festenummer.hashCode());
        String $seksjonsnummer = this.getSeksjonsnummer();
        result = result * 59 + ($seksjonsnummer == null ? 43 : $seksjonsnummer.hashCode());
        return result;
    }

    public String toString() {
        return "Matrikkel(kommunenummer=" + this.getKommunenummer() + ", gaardsnummer=" + this.getGaardsnummer() + ", bruksnummer=" + this.getBruksnummer() + ", festenummer=" + this.getFestenummer() + ", seksjonsnummer=" + this.getSeksjonsnummer() + ")";
    }

    public Matrikkel(String kommunenummer, String gaardsnummer, String bruksnummer, String festenummer, String seksjonsnummer) {
        this.kommunenummer = kommunenummer;
        this.gaardsnummer = gaardsnummer;
        this.bruksnummer = bruksnummer;
        this.festenummer = festenummer;
        this.seksjonsnummer = seksjonsnummer;
    }

    private Matrikkel() {
        this.kommunenummer = null;
        this.gaardsnummer = null;
        this.bruksnummer = null;
        this.festenummer = null;
        this.seksjonsnummer = null;
    }

    public Matrikkel withKommunenummer(String kommunenummer) {
        return this.kommunenummer == kommunenummer ? this : new Matrikkel(kommunenummer, this.gaardsnummer, this.bruksnummer, this.festenummer, this.seksjonsnummer);
    }

    public Matrikkel withGaardsnummer(String gaardsnummer) {
        return this.gaardsnummer == gaardsnummer ? this : new Matrikkel(this.kommunenummer, gaardsnummer, this.bruksnummer, this.festenummer, this.seksjonsnummer);
    }

    public Matrikkel withBruksnummer(String bruksnummer) {
        return this.bruksnummer == bruksnummer ? this : new Matrikkel(this.kommunenummer, this.gaardsnummer, bruksnummer, this.festenummer, this.seksjonsnummer);
    }

    public Matrikkel withFestenummer(String festenummer) {
        return this.festenummer == festenummer ? this : new Matrikkel(this.kommunenummer, this.gaardsnummer, this.bruksnummer, festenummer, this.seksjonsnummer);
    }

    public Matrikkel withSeksjonsnummer(String seksjonsnummer) {
        return this.seksjonsnummer == seksjonsnummer ? this : new Matrikkel(this.kommunenummer, this.gaardsnummer, this.bruksnummer, this.festenummer, seksjonsnummer);
    }
}

