/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.datatypes.types.pickup;

import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import no.digipost.api.datatypes.documentation.Description;
import no.digipost.api.datatypes.types.Address;

@XmlType
public final class PickupPlace {
    @XmlElement(name="name", required=true)
    @Description(value="The pickup place name")
    @NotNull
    private final String name;
    @XmlElement(name="code", required=true)
    @Description(value="The pickup code")
    private final String code;
    @XmlElement(name="instruction", required=true)
    @Description(value="instructions for fetching the parcel")
    private final String instruction;
    @XmlElement(name="shelf-location")
    @Description(value="shelf location at pickup point")
    private final String shelfLocation;
    @XmlElement
    @NotNull
    private final Address address;
    public static final PickupPlace EXAMPLE = new PickupPlace("Coop Mega", "RC89", "M\u00e5 hentes innen 010180", "H32", Address.EXAMPLE);

    public String getName() {
        return this.name;
    }

    public String getCode() {
        return this.code;
    }

    public String getInstruction() {
        return this.instruction;
    }

    public String getShelfLocation() {
        return this.shelfLocation;
    }

    public Address getAddress() {
        return this.address;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PickupPlace)) {
            return false;
        }
        PickupPlace other = (PickupPlace)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$instruction = this.getInstruction();
        String other$instruction = other.getInstruction();
        if (this$instruction == null ? other$instruction != null : !this$instruction.equals(other$instruction)) {
            return false;
        }
        String this$shelfLocation = this.getShelfLocation();
        String other$shelfLocation = other.getShelfLocation();
        if (this$shelfLocation == null ? other$shelfLocation != null : !this$shelfLocation.equals(other$shelfLocation)) {
            return false;
        }
        Address this$address = this.getAddress();
        Address other$address = other.getAddress();
        return !(this$address == null ? other$address != null : !((Object)this$address).equals(other$address));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $instruction = this.getInstruction();
        result = result * 59 + ($instruction == null ? 43 : $instruction.hashCode());
        String $shelfLocation = this.getShelfLocation();
        result = result * 59 + ($shelfLocation == null ? 43 : $shelfLocation.hashCode());
        Address $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
        return result;
    }

    public String toString() {
        return "PickupPlace(name=" + this.getName() + ", code=" + this.getCode() + ", instruction=" + this.getInstruction() + ", shelfLocation=" + this.getShelfLocation() + ", address=" + this.getAddress() + ")";
    }

    public PickupPlace(String name, String code, String instruction, String shelfLocation, Address address) {
        this.name = name;
        this.code = code;
        this.instruction = instruction;
        this.shelfLocation = shelfLocation;
        this.address = address;
    }

    private PickupPlace() {
        this.name = null;
        this.code = null;
        this.instruction = null;
        this.shelfLocation = null;
        this.address = null;
    }

    public PickupPlace withName(String name) {
        return this.name == name ? this : new PickupPlace(name, this.code, this.instruction, this.shelfLocation, this.address);
    }

    public PickupPlace withCode(String code) {
        return this.code == code ? this : new PickupPlace(this.name, code, this.instruction, this.shelfLocation, this.address);
    }

    public PickupPlace withInstruction(String instruction) {
        return this.instruction == instruction ? this : new PickupPlace(this.name, this.code, instruction, this.shelfLocation, this.address);
    }

    public PickupPlace withShelfLocation(String shelfLocation) {
        return this.shelfLocation == shelfLocation ? this : new PickupPlace(this.name, this.code, this.instruction, shelfLocation, this.address);
    }

    public PickupPlace withAddress(Address address) {
        return this.address == address ? this : new PickupPlace(this.name, this.code, this.instruction, this.shelfLocation, address);
    }
}

