/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.datatypes.types.proof;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import no.digipost.api.datatypes.documentation.Description;

@XmlType
public final class CalendarDate {
    @XmlElement(name="month", required=true)
    @Size(min=1, max=12)
    @NotNull
    @Description(value="")
    private final @Size(min=1, max=12) @NotNull Integer month;
    @XmlElement(name="day", required=true)
    @Size(min=1, max=31)
    @NotNull
    @Description(value="")
    private final @Size(min=1, max=31) @NotNull Integer day;
    @XmlElement(name="hour", defaultValue="0")
    @Size(min=0, max=23)
    @Description(value="")
    private final @Size(min=0, max=23) Integer hour;
    @XmlElement(name="min", defaultValue="0")
    @Size(min=0, max=59)
    @Description(value="")
    private final @Size(min=0, max=59) Integer min;
    @XmlElement(name="time-zone", defaultValue="+01:00")
    @Pattern(regexp="Z|[+-][01]\\d:{0,1}[0-5]\\d|[+-][01]\\d")
    @Description(value="Deprecated, do not use. Will be ignored.")
    private final @Pattern(regexp="Z|[+-][01]\\d:{0,1}[0-5]\\d|[+-][01]\\d") String timeZone;
    public static CalendarDate EXAMPLE = new CalendarDate(5, 9, 0, 0);

    @Deprecated
    public CalendarDate(Integer month, Integer day, Integer hour, Integer min, String timeZone) {
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.min = min;
        this.timeZone = timeZone;
    }

    public CalendarDate(Integer month, Integer day, Integer hour, Integer min) {
        this(month, day, hour, min, null);
    }

    public Integer getMonth() {
        return this.month;
    }

    public Integer getDay() {
        return this.day;
    }

    public Integer getHour() {
        return this.hour;
    }

    public Integer getMin() {
        return this.min;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalendarDate)) {
            return false;
        }
        CalendarDate other = (CalendarDate)o;
        Integer this$month = this.getMonth();
        Integer other$month = other.getMonth();
        if (this$month == null ? other$month != null : !((Object)this$month).equals(other$month)) {
            return false;
        }
        Integer this$day = this.getDay();
        Integer other$day = other.getDay();
        if (this$day == null ? other$day != null : !((Object)this$day).equals(other$day)) {
            return false;
        }
        Integer this$hour = this.getHour();
        Integer other$hour = other.getHour();
        if (this$hour == null ? other$hour != null : !((Object)this$hour).equals(other$hour)) {
            return false;
        }
        Integer this$min = this.getMin();
        Integer other$min = other.getMin();
        if (this$min == null ? other$min != null : !((Object)this$min).equals(other$min)) {
            return false;
        }
        String this$timeZone = this.getTimeZone();
        String other$timeZone = other.getTimeZone();
        return !(this$timeZone == null ? other$timeZone != null : !this$timeZone.equals(other$timeZone));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $month = this.getMonth();
        result = result * 59 + ($month == null ? 43 : ((Object)$month).hashCode());
        Integer $day = this.getDay();
        result = result * 59 + ($day == null ? 43 : ((Object)$day).hashCode());
        Integer $hour = this.getHour();
        result = result * 59 + ($hour == null ? 43 : ((Object)$hour).hashCode());
        Integer $min = this.getMin();
        result = result * 59 + ($min == null ? 43 : ((Object)$min).hashCode());
        String $timeZone = this.getTimeZone();
        result = result * 59 + ($timeZone == null ? 43 : $timeZone.hashCode());
        return result;
    }

    public String toString() {
        return "CalendarDate(month=" + this.getMonth() + ", day=" + this.getDay() + ", hour=" + this.getHour() + ", min=" + this.getMin() + ", timeZone=" + this.getTimeZone() + ")";
    }

    private CalendarDate() {
        this.month = null;
        this.day = null;
        this.hour = null;
        this.min = null;
        this.timeZone = null;
    }

    public CalendarDate withMonth(Integer month) {
        return this.month == month ? this : new CalendarDate(month, this.day, this.hour, this.min, this.timeZone);
    }

    public CalendarDate withDay(Integer day) {
        return this.day == day ? this : new CalendarDate(this.month, day, this.hour, this.min, this.timeZone);
    }

    public CalendarDate withHour(Integer hour) {
        return this.hour == hour ? this : new CalendarDate(this.month, this.day, hour, this.min, this.timeZone);
    }

    public CalendarDate withMin(Integer min) {
        return this.min == min ? this : new CalendarDate(this.month, this.day, this.hour, min, this.timeZone);
    }

    public CalendarDate withTimeZone(String timeZone) {
        return this.timeZone == timeZone ? this : new CalendarDate(this.month, this.day, this.hour, this.min, timeZone);
    }
}

