/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.datatypes.types.proof;

import java.time.LocalDateTime;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import no.digipost.api.datatypes.documentation.Description;
import no.digipost.api.datatypes.validation.ValidPeriode;

@XmlType
@ValidPeriode
public final class Period {
    @XmlElement(name="from")
    @Description(value="ISO8601 full DateTime")
    private final LocalDateTime from;
    @XmlElement(name="to")
    @Description(value="ISO8601 full DateTime")
    private final LocalDateTime to;
    public static Period EXAMPLE = new Period(LocalDateTime.of(2019, 5, 23, 10, 0, 0, 0), LocalDateTime.of(2019, 5, 23, 16, 0, 0, 0));

    public String getISO8601() {
        if (this.from != null && this.to != null) {
            return this.from.toString() + "/" + this.to.toString();
        }
        if (this.from != null) {
            return this.from.toString() + "/..";
        }
        if (this.to != null) {
            return "../" + this.to.toString();
        }
        return "../..";
    }

    public LocalDateTime getFrom() {
        return this.from;
    }

    public LocalDateTime getTo() {
        return this.to;
    }

    public String toString() {
        return "Period(from=" + this.getFrom() + ", to=" + this.getTo() + ")";
    }

    public Period(LocalDateTime from, LocalDateTime to) {
        this.from = from;
        this.to = to;
    }

    private Period() {
        this.from = null;
        this.to = null;
    }

    public Period withFrom(LocalDateTime from) {
        return this.from == from ? this : new Period(from, this.to);
    }

    public Period withTo(LocalDateTime to) {
        return this.to == to ? this : new Period(this.from, to);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Period)) {
            return false;
        }
        Period other = (Period)o;
        LocalDateTime this$from = this.getFrom();
        LocalDateTime other$from = other.getFrom();
        if (this$from == null ? other$from != null : !((Object)this$from).equals(other$from)) {
            return false;
        }
        LocalDateTime this$to = this.getTo();
        LocalDateTime other$to = other.getTo();
        return !(this$to == null ? other$to != null : !((Object)this$to).equals(other$to));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LocalDateTime $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : ((Object)$from).hashCode());
        LocalDateTime $to = this.getTo();
        result = result * 59 + ($to == null ? 43 : ((Object)$to).hashCode());
        return result;
    }
}

