/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.datatypes.types.proof;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import no.digipost.api.datatypes.DataType;
import no.digipost.api.datatypes.documentation.Description;
import no.digipost.api.datatypes.types.Info;
import no.digipost.api.datatypes.types.Language;
import no.digipost.api.datatypes.types.proof.ProofHolder;
import no.digipost.api.datatypes.types.proof.ValidPeriod;

@XmlRootElement
@Description(value="Represents a legal document (Certificate, Licence, Permit, etc.) issued to a single person, valid for one or more time periods.")
public final class Proof
implements DataType {
    @XmlElement(name="authorizer-name")
    @Size(max=30)
    @Description(value="Name of e.g. the organization issuing this proof")
    private final @Size(max=30) String authorizerName;
    @XmlElement(name="background-color")
    @Pattern(regexp="#[A-SFa-f0-9]{6}")
    @Description(value="#RRGGBB color code")
    private final @Pattern(regexp="#[A-SFa-f0-9]{6}") String backgroundColor;
    @XmlElement(name="issued-time")
    @Description(value="The point of time the proof is issued")
    private final ZonedDateTime issuedTime;
    @XmlElement(name="valid-period", required=true)
    @NotNull
    @Description(value="A description of when the proof is valid")
    private final ValidPeriod validPeriod;
    @XmlElement(name="proof-holder", required=true)
    @NotNull
    @Description(value="")
    private final ProofHolder proofHolder;
    @XmlElement(name="title", required=true)
    @NotNull
    @Size(max=255)
    @Description(value="")
    private final @NotNull @Size(max=255) String title;
    @XmlElement(name="proof-id-name")
    @Size(max=100)
    @Description(value="A name describing the content of the proofIdValue field")
    private final @Size(max=100) String proofIdName;
    @XmlElement(name="proof-id-value")
    @Size(max=250)
    @Description(value="A field for extra information identifying this proof, such as a membership number")
    private final @Size(max=250) String proofIdValue;
    @XmlElement(name="attribute")
    @Size(max=5)
    @Description(value="Extra information for the proof, a set of key-value pairs")
    private final @Size(max=5) List<Info> attribute;
    @XmlElement(name="info")
    @Size(max=3)
    @Description(value="Extra instructions for the holder of the proof, such as special terms")
    private final @Size(max=3) List<Info> info;
    @XmlElement(defaultValue="NB")
    @Description(value="Languange for the document")
    private final Language language;
    public static Proof EXAMPLE = new Proof("Bekkestua Bibliotek", "#e1e1e1", ZonedDateTime.of(2019, 5, 23, 10, 0, 0, 0, ZoneId.of("+02:00")), ValidPeriod.EXAMPLE, ProofHolder.EXAMPLE, "L\u00e5nekort", "L\u00e5nekortnummer", "a-132415124-xyzzy-21341", Collections.singletonList(new Info("Kaffeklubb", "Premium deluxe medlem")), Collections.singletonList(new Info("Regler", "Det er ikke lov \u00e5 rive ut sider i b\u00f8kene, eller s\u00f8le med ketchup. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec aliquet urna condimentum, pulvinar neque ac, tempor tellus. Vestibulum ante ipsum primis in faucibus orci luctus et ")), Language.NB);

    public String getAuthorizerName() {
        return this.authorizerName;
    }

    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public ZonedDateTime getIssuedTime() {
        return this.issuedTime;
    }

    public ValidPeriod getValidPeriod() {
        return this.validPeriod;
    }

    public ProofHolder getProofHolder() {
        return this.proofHolder;
    }

    public String getTitle() {
        return this.title;
    }

    public String getProofIdName() {
        return this.proofIdName;
    }

    public String getProofIdValue() {
        return this.proofIdValue;
    }

    public List<Info> getAttribute() {
        return this.attribute;
    }

    public List<Info> getInfo() {
        return this.info;
    }

    public Language getLanguage() {
        return this.language;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Proof)) {
            return false;
        }
        Proof other = (Proof)o;
        String this$authorizerName = this.getAuthorizerName();
        String other$authorizerName = other.getAuthorizerName();
        if (this$authorizerName == null ? other$authorizerName != null : !this$authorizerName.equals(other$authorizerName)) {
            return false;
        }
        String this$backgroundColor = this.getBackgroundColor();
        String other$backgroundColor = other.getBackgroundColor();
        if (this$backgroundColor == null ? other$backgroundColor != null : !this$backgroundColor.equals(other$backgroundColor)) {
            return false;
        }
        ZonedDateTime this$issuedTime = this.getIssuedTime();
        ZonedDateTime other$issuedTime = other.getIssuedTime();
        if (this$issuedTime == null ? other$issuedTime != null : !((Object)this$issuedTime).equals(other$issuedTime)) {
            return false;
        }
        ValidPeriod this$validPeriod = this.getValidPeriod();
        ValidPeriod other$validPeriod = other.getValidPeriod();
        if (this$validPeriod == null ? other$validPeriod != null : !((Object)this$validPeriod).equals(other$validPeriod)) {
            return false;
        }
        ProofHolder this$proofHolder = this.getProofHolder();
        ProofHolder other$proofHolder = other.getProofHolder();
        if (this$proofHolder == null ? other$proofHolder != null : !((Object)this$proofHolder).equals(other$proofHolder)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$proofIdName = this.getProofIdName();
        String other$proofIdName = other.getProofIdName();
        if (this$proofIdName == null ? other$proofIdName != null : !this$proofIdName.equals(other$proofIdName)) {
            return false;
        }
        String this$proofIdValue = this.getProofIdValue();
        String other$proofIdValue = other.getProofIdValue();
        if (this$proofIdValue == null ? other$proofIdValue != null : !this$proofIdValue.equals(other$proofIdValue)) {
            return false;
        }
        List<Info> this$attribute = this.getAttribute();
        List<Info> other$attribute = other.getAttribute();
        if (this$attribute == null ? other$attribute != null : !((Object)this$attribute).equals(other$attribute)) {
            return false;
        }
        List<Info> this$info = this.getInfo();
        List<Info> other$info = other.getInfo();
        if (this$info == null ? other$info != null : !((Object)this$info).equals(other$info)) {
            return false;
        }
        Language this$language = this.getLanguage();
        Language other$language = other.getLanguage();
        return !(this$language == null ? other$language != null : !((Object)((Object)this$language)).equals((Object)other$language));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $authorizerName = this.getAuthorizerName();
        result = result * 59 + ($authorizerName == null ? 43 : $authorizerName.hashCode());
        String $backgroundColor = this.getBackgroundColor();
        result = result * 59 + ($backgroundColor == null ? 43 : $backgroundColor.hashCode());
        ZonedDateTime $issuedTime = this.getIssuedTime();
        result = result * 59 + ($issuedTime == null ? 43 : ((Object)$issuedTime).hashCode());
        ValidPeriod $validPeriod = this.getValidPeriod();
        result = result * 59 + ($validPeriod == null ? 43 : ((Object)$validPeriod).hashCode());
        ProofHolder $proofHolder = this.getProofHolder();
        result = result * 59 + ($proofHolder == null ? 43 : ((Object)$proofHolder).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $proofIdName = this.getProofIdName();
        result = result * 59 + ($proofIdName == null ? 43 : $proofIdName.hashCode());
        String $proofIdValue = this.getProofIdValue();
        result = result * 59 + ($proofIdValue == null ? 43 : $proofIdValue.hashCode());
        List<Info> $attribute = this.getAttribute();
        result = result * 59 + ($attribute == null ? 43 : ((Object)$attribute).hashCode());
        List<Info> $info = this.getInfo();
        result = result * 59 + ($info == null ? 43 : ((Object)$info).hashCode());
        Language $language = this.getLanguage();
        result = result * 59 + ($language == null ? 43 : ((Object)((Object)$language)).hashCode());
        return result;
    }

    public String toString() {
        return "Proof(authorizerName=" + this.getAuthorizerName() + ", backgroundColor=" + this.getBackgroundColor() + ", issuedTime=" + this.getIssuedTime() + ", validPeriod=" + this.getValidPeriod() + ", proofHolder=" + this.getProofHolder() + ", title=" + this.getTitle() + ", proofIdName=" + this.getProofIdName() + ", proofIdValue=" + this.getProofIdValue() + ", attribute=" + this.getAttribute() + ", info=" + this.getInfo() + ", language=" + (Object)((Object)this.getLanguage()) + ")";
    }

    public Proof(String authorizerName, String backgroundColor, ZonedDateTime issuedTime, ValidPeriod validPeriod, ProofHolder proofHolder, String title, String proofIdName, String proofIdValue, List<Info> attribute, List<Info> info, Language language) {
        this.authorizerName = authorizerName;
        this.backgroundColor = backgroundColor;
        this.issuedTime = issuedTime;
        this.validPeriod = validPeriod;
        this.proofHolder = proofHolder;
        this.title = title;
        this.proofIdName = proofIdName;
        this.proofIdValue = proofIdValue;
        this.attribute = attribute;
        this.info = info;
        this.language = language;
    }

    private Proof() {
        this.authorizerName = null;
        this.backgroundColor = null;
        this.issuedTime = null;
        this.validPeriod = null;
        this.proofHolder = null;
        this.title = null;
        this.proofIdName = null;
        this.proofIdValue = null;
        this.attribute = null;
        this.info = null;
        this.language = null;
    }

    public Proof withAuthorizerName(String authorizerName) {
        return this.authorizerName == authorizerName ? this : new Proof(authorizerName, this.backgroundColor, this.issuedTime, this.validPeriod, this.proofHolder, this.title, this.proofIdName, this.proofIdValue, this.attribute, this.info, this.language);
    }

    public Proof withBackgroundColor(String backgroundColor) {
        return this.backgroundColor == backgroundColor ? this : new Proof(this.authorizerName, backgroundColor, this.issuedTime, this.validPeriod, this.proofHolder, this.title, this.proofIdName, this.proofIdValue, this.attribute, this.info, this.language);
    }

    public Proof withIssuedTime(ZonedDateTime issuedTime) {
        return this.issuedTime == issuedTime ? this : new Proof(this.authorizerName, this.backgroundColor, issuedTime, this.validPeriod, this.proofHolder, this.title, this.proofIdName, this.proofIdValue, this.attribute, this.info, this.language);
    }

    public Proof withValidPeriod(ValidPeriod validPeriod) {
        return this.validPeriod == validPeriod ? this : new Proof(this.authorizerName, this.backgroundColor, this.issuedTime, validPeriod, this.proofHolder, this.title, this.proofIdName, this.proofIdValue, this.attribute, this.info, this.language);
    }

    public Proof withProofHolder(ProofHolder proofHolder) {
        return this.proofHolder == proofHolder ? this : new Proof(this.authorizerName, this.backgroundColor, this.issuedTime, this.validPeriod, proofHolder, this.title, this.proofIdName, this.proofIdValue, this.attribute, this.info, this.language);
    }

    public Proof withTitle(String title) {
        return this.title == title ? this : new Proof(this.authorizerName, this.backgroundColor, this.issuedTime, this.validPeriod, this.proofHolder, title, this.proofIdName, this.proofIdValue, this.attribute, this.info, this.language);
    }

    public Proof withProofIdName(String proofIdName) {
        return this.proofIdName == proofIdName ? this : new Proof(this.authorizerName, this.backgroundColor, this.issuedTime, this.validPeriod, this.proofHolder, this.title, proofIdName, this.proofIdValue, this.attribute, this.info, this.language);
    }

    public Proof withProofIdValue(String proofIdValue) {
        return this.proofIdValue == proofIdValue ? this : new Proof(this.authorizerName, this.backgroundColor, this.issuedTime, this.validPeriod, this.proofHolder, this.title, this.proofIdName, proofIdValue, this.attribute, this.info, this.language);
    }

    public Proof withAttribute(List<Info> attribute) {
        return this.attribute == attribute ? this : new Proof(this.authorizerName, this.backgroundColor, this.issuedTime, this.validPeriod, this.proofHolder, this.title, this.proofIdName, this.proofIdValue, attribute, this.info, this.language);
    }

    public Proof withInfo(List<Info> info) {
        return this.info == info ? this : new Proof(this.authorizerName, this.backgroundColor, this.issuedTime, this.validPeriod, this.proofHolder, this.title, this.proofIdName, this.proofIdValue, this.attribute, info, this.language);
    }

    public Proof withLanguage(Language language) {
        return this.language == language ? this : new Proof(this.authorizerName, this.backgroundColor, this.issuedTime, this.validPeriod, this.proofHolder, this.title, this.proofIdName, this.proofIdValue, this.attribute, this.info, language);
    }
}

