/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.datatypes.types.proof;

import java.time.LocalDateTime;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import no.digipost.api.datatypes.documentation.Description;
import no.digipost.api.datatypes.types.proof.CalendarDate;

@XmlType
public final class YearlyRepeatingPeriod {
    @XmlElement(name="start-year")
    @Description(value="")
    private final Integer startYear;
    @XmlElement(name="end-year")
    @Description(value="")
    private final Integer endYear;
    @XmlElement(name="from", required=true)
    @NotNull
    @Description(value="The date each year the proof becomes valid")
    private final CalendarDate from;
    @XmlElement(name="to", required=true)
    @NotNull
    @Description(value="The date each year the proof stops being valid")
    private final CalendarDate to;
    public static YearlyRepeatingPeriod EXAMPLE = new YearlyRepeatingPeriod(2020, 2022, new CalendarDate(1, 1, null, null), new CalendarDate(12, 31, 0, 0));

    public String getISO8601() {
        String startDate = YearlyRepeatingPeriod.writeLocalDate(this.from, this.startYear);
        String endDate = YearlyRepeatingPeriod.writeLocalDate(this.to, this.endYear);
        if (this.startYear != null && this.endYear != null) {
            return "R/" + startDate + "/" + endDate;
        }
        if (this.endYear != null) {
            return "R/" + startDate.substring(5) + "/" + endDate;
        }
        if (this.startYear != null) {
            return "R/" + startDate + "/" + endDate.substring(5);
        }
        return "R/" + startDate.substring(5) + "/" + endDate.substring(5);
    }

    private static String writeLocalDate(CalendarDate t_date, Integer year) {
        int t_minute = 0;
        int t_hour = 0;
        int t_day = 1;
        int t_month = 1;
        t_minute = t_date.getMin() != null ? t_date.getMin() : t_minute;
        t_hour = t_date.getHour() != null ? t_date.getHour() : t_hour;
        t_day = t_date.getDay() != null ? t_date.getDay() : t_day;
        t_month = t_date.getMonth() != null ? t_date.getMonth() : t_month;
        int t_year = year != null ? year : 2019;
        return LocalDateTime.of(t_year, t_month, t_day, t_hour, t_minute, 0, 0).toString();
    }

    public Integer getStartYear() {
        return this.startYear;
    }

    public Integer getEndYear() {
        return this.endYear;
    }

    public CalendarDate getFrom() {
        return this.from;
    }

    public CalendarDate getTo() {
        return this.to;
    }

    public String toString() {
        return "YearlyRepeatingPeriod(startYear=" + this.getStartYear() + ", endYear=" + this.getEndYear() + ", from=" + this.getFrom() + ", to=" + this.getTo() + ")";
    }

    public YearlyRepeatingPeriod(Integer startYear, Integer endYear, CalendarDate from, CalendarDate to) {
        this.startYear = startYear;
        this.endYear = endYear;
        this.from = from;
        this.to = to;
    }

    private YearlyRepeatingPeriod() {
        this.startYear = null;
        this.endYear = null;
        this.from = null;
        this.to = null;
    }

    public YearlyRepeatingPeriod withStartYear(Integer startYear) {
        return this.startYear == startYear ? this : new YearlyRepeatingPeriod(startYear, this.endYear, this.from, this.to);
    }

    public YearlyRepeatingPeriod withEndYear(Integer endYear) {
        return this.endYear == endYear ? this : new YearlyRepeatingPeriod(this.startYear, endYear, this.from, this.to);
    }

    public YearlyRepeatingPeriod withFrom(CalendarDate from) {
        return this.from == from ? this : new YearlyRepeatingPeriod(this.startYear, this.endYear, from, this.to);
    }

    public YearlyRepeatingPeriod withTo(CalendarDate to) {
        return this.to == to ? this : new YearlyRepeatingPeriod(this.startYear, this.endYear, this.from, to);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof YearlyRepeatingPeriod)) {
            return false;
        }
        YearlyRepeatingPeriod other = (YearlyRepeatingPeriod)o;
        Integer this$startYear = this.getStartYear();
        Integer other$startYear = other.getStartYear();
        if (this$startYear == null ? other$startYear != null : !((Object)this$startYear).equals(other$startYear)) {
            return false;
        }
        Integer this$endYear = this.getEndYear();
        Integer other$endYear = other.getEndYear();
        if (this$endYear == null ? other$endYear != null : !((Object)this$endYear).equals(other$endYear)) {
            return false;
        }
        CalendarDate this$from = this.getFrom();
        CalendarDate other$from = other.getFrom();
        if (this$from == null ? other$from != null : !((Object)this$from).equals(other$from)) {
            return false;
        }
        CalendarDate this$to = this.getTo();
        CalendarDate other$to = other.getTo();
        return !(this$to == null ? other$to != null : !((Object)this$to).equals(other$to));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $startYear = this.getStartYear();
        result = result * 59 + ($startYear == null ? 43 : ((Object)$startYear).hashCode());
        Integer $endYear = this.getEndYear();
        result = result * 59 + ($endYear == null ? 43 : ((Object)$endYear).hashCode());
        CalendarDate $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : ((Object)$from).hashCode());
        CalendarDate $to = this.getTo();
        result = result * 59 + ($to == null ? 43 : ((Object)$to).hashCode());
        return result;
    }
}

