/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.datatypes.types.receipt;

import java.math.BigDecimal;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import no.digipost.api.datatypes.documentation.Description;
import no.digipost.api.datatypes.types.ForeignCurrencyPayment;

@XmlType
@Description(value="Contains details about a payment carried out as part of this purchase")
public final class Payment {
    @XmlElement
    @Description(value="Payment type. Examples: Credit Card, BankAxept, Cash")
    private final String type;
    @XmlElement(name="card-number")
    @Description(value="The obscured card number associated with the purchase")
    @Size(max=25)
    private final @Size(max=25) String cardNumber;
    @XmlElement
    private final String cardName;
    @XmlElement
    @Description(value="Amount paid in this payment")
    private final BigDecimal amount;
    @XmlElement(name="currency-code")
    @Size(max=3)
    @Description(value="Currency of the payment, ISO4217. Example: NOK")
    private final @Size(max=3) String currencyCode;
    @XmlElement(name="foreign-currency-payment")
    private final ForeignCurrencyPayment foreignCurrencyPayment;
    public static final Payment EXAMPLE = new Payment("Bank Axept", "************1234", "Visa", new BigDecimal("100.00"), "NOK", ForeignCurrencyPayment.EXAMPLE);

    public String getType() {
        return this.type;
    }

    public String getCardNumber() {
        return this.cardNumber;
    }

    public String getCardName() {
        return this.cardName;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public ForeignCurrencyPayment getForeignCurrencyPayment() {
        return this.foreignCurrencyPayment;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Payment)) {
            return false;
        }
        Payment other = (Payment)o;
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$cardNumber = this.getCardNumber();
        String other$cardNumber = other.getCardNumber();
        if (this$cardNumber == null ? other$cardNumber != null : !this$cardNumber.equals(other$cardNumber)) {
            return false;
        }
        String this$cardName = this.getCardName();
        String other$cardName = other.getCardName();
        if (this$cardName == null ? other$cardName != null : !this$cardName.equals(other$cardName)) {
            return false;
        }
        BigDecimal this$amount = this.getAmount();
        BigDecimal other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        String this$currencyCode = this.getCurrencyCode();
        String other$currencyCode = other.getCurrencyCode();
        if (this$currencyCode == null ? other$currencyCode != null : !this$currencyCode.equals(other$currencyCode)) {
            return false;
        }
        ForeignCurrencyPayment this$foreignCurrencyPayment = this.getForeignCurrencyPayment();
        ForeignCurrencyPayment other$foreignCurrencyPayment = other.getForeignCurrencyPayment();
        return !(this$foreignCurrencyPayment == null ? other$foreignCurrencyPayment != null : !((Object)this$foreignCurrencyPayment).equals(other$foreignCurrencyPayment));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $cardNumber = this.getCardNumber();
        result = result * 59 + ($cardNumber == null ? 43 : $cardNumber.hashCode());
        String $cardName = this.getCardName();
        result = result * 59 + ($cardName == null ? 43 : $cardName.hashCode());
        BigDecimal $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        String $currencyCode = this.getCurrencyCode();
        result = result * 59 + ($currencyCode == null ? 43 : $currencyCode.hashCode());
        ForeignCurrencyPayment $foreignCurrencyPayment = this.getForeignCurrencyPayment();
        result = result * 59 + ($foreignCurrencyPayment == null ? 43 : ((Object)$foreignCurrencyPayment).hashCode());
        return result;
    }

    public String toString() {
        return "Payment(type=" + this.getType() + ", cardNumber=" + this.getCardNumber() + ", cardName=" + this.getCardName() + ", amount=" + this.getAmount() + ", currencyCode=" + this.getCurrencyCode() + ", foreignCurrencyPayment=" + this.getForeignCurrencyPayment() + ")";
    }

    public Payment(String type, String cardNumber, String cardName, BigDecimal amount, String currencyCode, ForeignCurrencyPayment foreignCurrencyPayment) {
        this.type = type;
        this.cardNumber = cardNumber;
        this.cardName = cardName;
        this.amount = amount;
        this.currencyCode = currencyCode;
        this.foreignCurrencyPayment = foreignCurrencyPayment;
    }

    private Payment() {
        this.type = null;
        this.cardNumber = null;
        this.cardName = null;
        this.amount = null;
        this.currencyCode = null;
        this.foreignCurrencyPayment = null;
    }

    public Payment withType(String type) {
        return this.type == type ? this : new Payment(type, this.cardNumber, this.cardName, this.amount, this.currencyCode, this.foreignCurrencyPayment);
    }

    public Payment withCardNumber(String cardNumber) {
        return this.cardNumber == cardNumber ? this : new Payment(this.type, cardNumber, this.cardName, this.amount, this.currencyCode, this.foreignCurrencyPayment);
    }

    public Payment withCardName(String cardName) {
        return this.cardName == cardName ? this : new Payment(this.type, this.cardNumber, cardName, this.amount, this.currencyCode, this.foreignCurrencyPayment);
    }

    public Payment withAmount(BigDecimal amount) {
        return this.amount == amount ? this : new Payment(this.type, this.cardNumber, this.cardName, amount, this.currencyCode, this.foreignCurrencyPayment);
    }

    public Payment withCurrencyCode(String currencyCode) {
        return this.currencyCode == currencyCode ? this : new Payment(this.type, this.cardNumber, this.cardName, this.amount, currencyCode, this.foreignCurrencyPayment);
    }

    public Payment withForeignCurrencyPayment(ForeignCurrencyPayment foreignCurrencyPayment) {
        return this.foreignCurrencyPayment == foreignCurrencyPayment ? this : new Payment(this.type, this.cardNumber, this.cardName, this.amount, this.currencyCode, foreignCurrencyPayment);
    }
}

