/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.print.validate;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.pdmodel.font.PDType0Font;

class PdfFontValidator {
    private static final Set<String> STANDARD_14_FONTS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("TIMES", "COURIER", "HELVETICA", "SYMBOL", "ZAPFDINGBATS")));
    private static final Set<String> WHITE_LISTED_FONTS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("ARIAL")));
    private static final Set<String> SUPPORTED_FONTS = Stream.concat(STANDARD_14_FONTS.stream(), WHITE_LISTED_FONTS.stream()).collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
    private static final String DASH_AND_WHITESPACE = "[\\-\\s]+";

    PdfFontValidator() {
    }

    public Collection<PDFont> getPageFonts(PDPage page) throws IOException {
        PDResources resources = page.getResources();
        if (resources != null) {
            LinkedHashSet<PDFont> fonts = new LinkedHashSet<PDFont>();
            for (COSName fontName : resources.getFontNames()) {
                fonts.add(resources.getFont(fontName));
            }
            return fonts;
        }
        return Collections.emptySet();
    }

    public List<PDFont> findNonSupportedFonts(Iterable<PDFont> fonter) {
        ArrayList<PDFont> nonSupported = new ArrayList<PDFont>();
        for (PDFont font : fonter) {
            if (font.isDamaged()) {
                nonSupported.add(font);
                continue;
            }
            PDFontDescriptor fontDescriptor = font.getFontDescriptor();
            if (fontDescriptor != null) {
                if (this.erFontDescriptorAkseptabelForPrint(fontDescriptor)) continue;
                nonSupported.add(font);
                continue;
            }
            if (font instanceof PDType0Font || this.erAkseptabelForPrint(font.getName())) continue;
            nonSupported.add(font);
        }
        return Collections.unmodifiableList(nonSupported);
    }

    private boolean erFontDescriptorAkseptabelForPrint(PDFontDescriptor fontDescriptor) {
        if (this.harIkkeEmbeddedFont(fontDescriptor)) {
            return this.erAkseptabelForPrint(fontDescriptor.getFontName());
        }
        return true;
    }

    private boolean erAkseptabelForPrint(String fontnavn) {
        if (fontnavn == null) {
            return false;
        }
        String normalisertFontnavn = fontnavn.replaceAll(DASH_AND_WHITESPACE, "").toUpperCase();
        for (String supportertFontnavn : SUPPORTED_FONTS) {
            if (!normalisertFontnavn.contains(supportertFontnavn)) continue;
            return true;
        }
        return false;
    }

    private boolean harIkkeEmbeddedFont(PDFontDescriptor fontDescriptor) {
        return fontDescriptor.getFontFile() == null && fontDescriptor.getFontFile2() == null && fontDescriptor.getFontFile3() == null;
    }
}

