/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.print.validate;

import java.util.Collections;
import java.util.List;
import no.digipost.print.validate.PdfValidationError;
import no.digipost.print.validate.PdfValidationSettings;

public final class PdfValidationResult {
    public static final PdfValidationResult EVERYTHING_OK = new PdfValidationResult(Collections.emptyList(), -1, new PdfValidationSettings.Bleed(0, 10));
    public final List<PdfValidationError> errors;
    public final PdfValidationSettings.Bleed bleed;
    public final boolean okForPrint;
    public final boolean okForWeb;
    public final int pages;
    private String toStringValue;

    PdfValidationResult(List<PdfValidationError> errors, int pages, PdfValidationSettings.Bleed bleed) {
        this.pages = pages;
        this.errors = errors != null ? Collections.unmodifiableList(errors) : Collections.emptyList();
        this.okForPrint = PdfValidationError.OK_FOR_PRINT.containsAll(this.errors);
        this.okForWeb = PdfValidationError.OK_FOR_WEB.containsAll(this.errors);
        this.bleed = bleed;
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public String toString() {
        if (this.toStringValue == null) {
            StringBuilder sb = new StringBuilder("[");
            sb.append(this.getClass().getSimpleName());
            for (PdfValidationError printPdfValideringsFeil : this.errors) {
                String err = printPdfValideringsFeil == PdfValidationError.UNSUPPORTED_DIMENSIONS ? String.format(PdfValidationError.UNSUPPORTED_DIMENSIONS.toString(), 210 - this.bleed.negativeBleedInMM, 210 + this.bleed.positiveBleedInMM, 297 - this.bleed.negativeBleedInMM, 297 + this.bleed.positiveBleedInMM) : printPdfValideringsFeil.toString();
                sb.append(" ");
                sb.append(err);
            }
            sb.append("]");
            this.toStringValue = sb.toString();
        }
        return this.toStringValue;
    }
}

