/**
 * Copyright (C) Posten Norge AS
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package no.digipost.api.client.internal.http;

import org.apache.http.client.utils.URIBuilder;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Map.Entry;

import static no.digipost.api.client.internal.ExceptionUtils.asUnchecked;

public final class UriUtils {

    public static URI withQueryParams(URI uri, Map<String, ?> queryParams) {
        try {
            URIBuilder uriBuilder = new URIBuilder(uri);
            for (Entry<String, ?> param : queryParams.entrySet()) {
                uriBuilder.setParameter(param.getKey(), param.getValue().toString());
            }
            return uriBuilder.build();
        } catch (URISyntaxException e) {
            throw asUnchecked(e);
        }
    }

    private UriUtils() {
    }
}
