/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.internal;

import jakarta.xml.bind.JAXB;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import no.digipost.api.client.BrokerId;
import no.digipost.api.client.DigipostClientConfig;
import no.digipost.api.client.EventLogger;
import no.digipost.api.client.SenderId;
import no.digipost.api.client.archive.ArchiveApi;
import no.digipost.api.client.batch.BatchApi;
import no.digipost.api.client.delivery.MessageDeliveryApi;
import no.digipost.api.client.document.DocumentApi;
import no.digipost.api.client.errorhandling.DigipostClientException;
import no.digipost.api.client.errorhandling.ErrorCode;
import no.digipost.api.client.inbox.InboxApi;
import no.digipost.api.client.internal.Cached;
import no.digipost.api.client.internal.ExceptionUtils;
import no.digipost.api.client.internal.http.Headers;
import no.digipost.api.client.internal.http.MultipartNoLengthCheckHttpEntity;
import no.digipost.api.client.internal.http.UriUtils;
import no.digipost.api.client.internal.http.request.interceptor.RequestContentHashFilter;
import no.digipost.api.client.internal.http.request.interceptor.RequestDateInterceptor;
import no.digipost.api.client.internal.http.request.interceptor.RequestSignatureInterceptor;
import no.digipost.api.client.internal.http.request.interceptor.RequestUserAgentInterceptor;
import no.digipost.api.client.internal.http.response.HttpResponseUtils;
import no.digipost.api.client.internal.http.response.interceptor.ResponseContentSHA256Interceptor;
import no.digipost.api.client.internal.http.response.interceptor.ResponseDateInterceptor;
import no.digipost.api.client.internal.http.response.interceptor.ResponseSignatureInterceptor;
import no.digipost.api.client.representations.AddDataLink;
import no.digipost.api.client.representations.AdditionalData;
import no.digipost.api.client.representations.Autocomplete;
import no.digipost.api.client.representations.DocumentEvents;
import no.digipost.api.client.representations.DocumentStatus;
import no.digipost.api.client.representations.EntryPoint;
import no.digipost.api.client.representations.ErrorMessage;
import no.digipost.api.client.representations.Identification;
import no.digipost.api.client.representations.Link;
import no.digipost.api.client.representations.MayHaveSender;
import no.digipost.api.client.representations.PersonalIdentificationNumber;
import no.digipost.api.client.representations.Recipients;
import no.digipost.api.client.representations.accounts.Tag;
import no.digipost.api.client.representations.accounts.Tags;
import no.digipost.api.client.representations.accounts.UserAccount;
import no.digipost.api.client.representations.accounts.UserInformation;
import no.digipost.api.client.representations.archive.Archive;
import no.digipost.api.client.representations.archive.ArchiveDocument;
import no.digipost.api.client.representations.archive.ArchiveDocumentContent;
import no.digipost.api.client.representations.archive.Archives;
import no.digipost.api.client.representations.batch.Batch;
import no.digipost.api.client.representations.inbox.Inbox;
import no.digipost.api.client.representations.inbox.InboxDocument;
import no.digipost.api.client.representations.sender.AuthorialSender;
import no.digipost.api.client.representations.sender.SenderInformation;
import no.digipost.api.client.representations.shareddocuments.ShareDocumentsRequestState;
import no.digipost.api.client.representations.shareddocuments.SharedDocumentContent;
import no.digipost.api.client.security.Digester;
import no.digipost.api.client.security.Signer;
import no.digipost.api.client.shareddocuments.SharedDocumentsApi;
import no.digipost.api.client.tag.TagApi;
import no.digipost.api.client.util.JAXBContextUtils;
import no.digipost.api.datatypes.DataType;
import no.digipost.api.datatypes.types.share.ShareDocumentsRequestSharingStopped;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpCoreContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiServiceImpl
implements MessageDeliveryApi,
InboxApi,
DocumentApi,
ArchiveApi,
BatchApi,
TagApi,
SharedDocumentsApi {
    private static final Logger LOG = LoggerFactory.getLogger(ApiServiceImpl.class);
    private static final String ENTRY_POINT = "/";
    private final BrokerId brokerId;
    private final CloseableHttpClient httpClient;
    private final URI digipostUrl;
    private final Cached cached;
    private final EventLogger eventLogger;
    private static final DateTimeFormatter DATE_TIME_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSxxx");

    public ApiServiceImpl(DigipostClientConfig config, HttpClientBuilder httpClientBuilder, BrokerId brokerId, Signer signer) {
        this.brokerId = brokerId;
        this.eventLogger = config.eventLogger.withDebugLogTo(LOG);
        this.digipostUrl = config.digipostApiUri;
        this.cached = new Cached(() -> this.fetchEntryPoint(Optional.empty()));
        this.httpClient = httpClientBuilder.addInterceptorLast((HttpRequestInterceptor)new RequestDateInterceptor(config.eventLogger, config.clock)).addInterceptorLast((HttpRequestInterceptor)new RequestUserAgentInterceptor()).addInterceptorLast((HttpRequestInterceptor)new RequestSignatureInterceptor(signer, config.eventLogger, new RequestContentHashFilter(config.eventLogger, Digester.sha256, "X-Content-SHA256"))).addInterceptorLast((HttpResponseInterceptor)new ResponseDateInterceptor(config.clock)).addInterceptorLast((HttpResponseInterceptor)new ResponseContentSHA256Interceptor()).addInterceptorLast((HttpResponseInterceptor)new ResponseSignatureInterceptor(this::getEntryPoint)).build();
        this.eventLogger.log("Initialiserte apache-klient mot " + config.digipostApiUri);
    }

    public EntryPoint getEntryPoint(SenderId senderId) {
        return Optional.ofNullable(senderId).map(specifiedSender -> (EntryPoint)this.cached.senderEntryPoint.get(specifiedSender, () -> this.fetchEntryPoint(Optional.of(specifiedSender)))).orElse(this.getEntryPoint());
    }

    public EntryPoint getEntryPoint() {
        return (EntryPoint)this.cached.entryPoint.get();
    }

    @Override
    public CloseableHttpResponse sendMultipartMessage(HttpEntity multipart) {
        MultipartNoLengthCheckHttpEntity multipartLengthCheckHttpEntity = new MultipartNoLengthCheckHttpEntity(multipart);
        EntryPoint entryPoint = this.getEntryPoint();
        HttpPost httpPost = new HttpPost(this.digipostUrl.resolve(entryPoint.getCreateMessageUri().getPath()));
        httpPost.setHeader(Headers.Accept_DIGIPOST_MEDIA_TYPE_V8);
        httpPost.setHeader("MIME-Version", "1.0");
        httpPost.removeHeaders("Accept-Encoding");
        httpPost.setEntity((HttpEntity)multipartLengthCheckHttpEntity);
        return this.send((HttpRequestBase)httpPost);
    }

    @Override
    public CloseableHttpResponse sendMultipartArchive(HttpEntity multipart) {
        MultipartNoLengthCheckHttpEntity multipartLengthCheckHttpEntity = new MultipartNoLengthCheckHttpEntity(multipart);
        EntryPoint entryPoint = this.getEntryPoint();
        HttpPost httpPost = new HttpPost(this.digipostUrl.resolve(entryPoint.getArchiveDocumentsUri().getPath()));
        httpPost.setHeader(Headers.Accept_DIGIPOST_MEDIA_TYPE_V8);
        httpPost.setHeader("MIME-Version", "1.0");
        httpPost.removeHeaders("Accept-Encoding");
        httpPost.setEntity((HttpEntity)multipartLengthCheckHttpEntity);
        return this.send((HttpRequestBase)httpPost);
    }

    @Override
    public Archive getArchiveDocument(URI uri) {
        return this.getEntity(Archive.class, uri.getPath());
    }

    @Override
    public ArchiveDocumentContent getArchiveDocumentContent(URI uri) {
        return this.getEntity(ArchiveDocumentContent.class, uri.getPath());
    }

    @Override
    public InputStream getArchiveDocumentContentStream(URI uri) {
        HttpGet httpGet = new HttpGet(uri);
        httpGet.setHeader("Accept", ContentType.WILDCARD.toString());
        HttpCoreContext httpCoreContext = HttpCoreContext.create();
        httpCoreContext.setAttribute("NOT_SIGNED_RESPONSE", (Object)true);
        return this.requestStream((HttpRequestBase)httpGet);
    }

    @Override
    public CloseableHttpResponse identifyAndGetEncryptionKey(Identification identification) {
        EntryPoint entryPoint = this.getEntryPoint();
        return this.sendDigipostMedia(identification, entryPoint.getIdentificationWithEncryptionKeyUri().getPath());
    }

    @Override
    public CloseableHttpResponse getEncryptionKey(URI location) {
        HttpGet httpGet = new HttpGet(location);
        httpGet.setHeader(Headers.Accept_DIGIPOST_MEDIA_TYPE_V8);
        return this.send((HttpRequestBase)httpGet);
    }

    @Override
    public CloseableHttpResponse getEncryptionCertificateForPrint() {
        EntryPoint entryPoint = this.getEntryPoint();
        HttpGet httpGet = new HttpGet(this.digipostUrl.resolve(entryPoint.getPrintEncryptionCertificate().getPath()));
        httpGet.setHeader(Headers.Accept_DIGIPOST_MEDIA_TYPE_V8);
        return this.send((HttpRequestBase)httpGet);
    }

    @Override
    public CloseableHttpResponse addData(AddDataLink addDataLink, AdditionalData data) {
        return this.sendDigipostMedia(data, addDataLink.getPath());
    }

    @Override
    public DocumentEvents getDocumentEvents(String organisation, String partId, SenderId senderId, ZonedDateTime from, ZonedDateTime to, int offset, int maxResults) {
        URIBuilder builder = new URIBuilder(this.digipostUrl.resolve(this.getEntryPoint().getDocumentEventsUri().getPath())).setParameter("from", DATE_TIME_FORMAT.format(from)).setParameter("to", DATE_TIME_FORMAT.format(to)).setParameter("offset", String.valueOf(offset)).setParameter("maxResults", String.valueOf(maxResults));
        if (organisation != null) {
            builder = builder.setParameter("org", organisation);
        }
        if (partId != null) {
            builder = builder.setParameter("part", partId);
        }
        if (senderId != null) {
            builder = builder.setParameter("sender", senderId.stringValue());
        }
        try {
            HttpGet httpGet = new HttpGet(builder.build());
            return this.requestEntity((HttpRequestBase)httpGet, DocumentEvents.class);
        }
        catch (URISyntaxException e) {
            throw ExceptionUtils.asUnchecked(e);
        }
    }

    @Override
    public DocumentStatus getDocumentStatus(Link linkToDocumentStatus) {
        return this.getDocumentStatus(linkToDocumentStatus.getUri().getPath());
    }

    @Override
    public DocumentStatus getDocumentStatus(SenderId senderId, UUID uuid) {
        return this.getDocumentStatus("/documents/" + senderId.stringValue() + ENTRY_POINT + uuid + "/status");
    }

    private DocumentStatus getDocumentStatus(String path) {
        HttpGet httpGet = new HttpGet(this.digipostUrl.resolve(path));
        return this.requestEntity((HttpRequestBase)httpGet, DocumentStatus.class);
    }

    @Override
    public InputStream getDocumentContent(String path) {
        HttpGet httpGet = new HttpGet(this.digipostUrl.resolve(path));
        return this.requestStream((HttpRequestBase)httpGet);
    }

    @Override
    public Recipients search(String searchString) {
        HttpGet httpGet = new HttpGet(this.digipostUrl.resolve(ApiServiceImpl.createEncodedURIPath(this.getEntryPoint().getSearchUri().getPath() + ENTRY_POINT + searchString)));
        return this.requestEntity((HttpRequestBase)httpGet, Recipients.class);
    }

    @Override
    public Autocomplete searchSuggest(String searchString) {
        HttpGet httpGet = new HttpGet(this.digipostUrl.resolve(ApiServiceImpl.createEncodedURIPath(this.getEntryPoint().getAutocompleteUri().getPath() + ENTRY_POINT + searchString)));
        return this.requestEntity((HttpRequestBase)httpGet, Autocomplete.class);
    }

    @Override
    public CloseableHttpResponse identifyRecipient(Identification identification) {
        return this.sendDigipostMedia(identification, this.getEntryPoint().getIdentificationUri().getPath());
    }

    private EntryPoint fetchEntryPoint(Optional<SenderId> senderId) throws IOException {
        HttpGet httpGet = new HttpGet(this.digipostUrl.resolve(senderId.map(s -> ENTRY_POINT + s.stringValue()).orElse(ENTRY_POINT)));
        httpGet.setHeader(Headers.Accept_DIGIPOST_MEDIA_TYPE_V8);
        HttpCoreContext httpCoreContext = HttpCoreContext.create();
        httpCoreContext.setAttribute("NOT_SIGNED_RESPONSE", (Object)true);
        try (CloseableHttpResponse response = this.send((HttpRequestBase)httpGet, (HttpContext)httpCoreContext);){
            if (response.getStatusLine().getStatusCode() == 200) {
                EntryPoint entryPoint = JAXBContextUtils.unmarshal(JAXBContextUtils.jaxbContext, response.getEntity().getContent(), EntryPoint.class);
                return entryPoint;
            }
            ErrorMessage errorMessage = JAXBContextUtils.unmarshal(JAXBContextUtils.jaxbContext, response.getEntity().getContent(), ErrorMessage.class);
            throw new DigipostClientException(errorMessage);
        }
    }

    @Override
    public SenderInformation getSenderInformation(SenderId senderId) {
        return (SenderInformation)this.cached.senderInformation.get((Object)senderId.stringValue(), () -> this.getEntity(SenderInformation.class, this.getEntryPoint().getSenderInformationUri().getPath() + ENTRY_POINT + senderId.stringValue()));
    }

    @Override
    public SenderInformation getSenderInformation(String orgnr, String avsenderenhet) {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("org_id", orgnr);
        if (avsenderenhet != null) {
            queryParams.put("part_id", avsenderenhet);
        }
        return (SenderInformation)this.cached.senderInformation.get((Object)(orgnr + Optional.ofNullable(avsenderenhet).map(enhet -> "-" + enhet).orElse("")), () -> this.getEntity(SenderInformation.class, this.getEntryPoint().getSenderInformationUri().getPath(), queryParams));
    }

    @Override
    public SenderInformation getSenderInformation(MayHaveSender mayHaveSender) {
        AuthorialSender authorialSender = AuthorialSender.resolve(this.brokerId, mayHaveSender);
        if (authorialSender.is(AuthorialSender.Type.ACCOUNT_ID)) {
            return this.getSenderInformation(authorialSender.getAccountId());
        }
        return this.getSenderInformation(authorialSender.getOrganization().organizationId, authorialSender.getOrganization().partId);
    }

    @Override
    public Archives getArchives(SenderId senderId) {
        URI uri = this.getEntryPoint(senderId).getArchivesUri();
        return this.getEntity(Archives.class, uri.getPath());
    }

    @Override
    public Archive getArchiveDocuments(URI uri) {
        return this.getEntity(Archive.class, ApiServiceImpl.pathWithQuery(uri));
    }

    @Override
    public Archives getArchiveDocumentsByReferenceId(SenderId senderId, String referenceId) {
        URI uri = this.getEntryPoint(senderId).getArchiveDocumentByReferenceUri(referenceId);
        return this.getEntity(Archives.class, uri.getPath());
    }

    @Override
    public Archive getArchiveDocumentByUUID(SenderId senderId, UUID uuid) {
        URI uri = this.getEntryPoint(senderId).getArchiveDocumentByUUIDUri(uuid);
        return this.getEntity(Archive.class, uri.getPath());
    }

    @Override
    public void deleteArchiveDocumentByUUID(URI deleteArchiveDocumentUri) {
        this.send((HttpRequestBase)new HttpDelete(this.digipostUrl.resolve(deleteArchiveDocumentUri.getPath())));
    }

    @Override
    public Archive addUniqueUUIDToArchiveDocument(SenderId senderId, UUID uuid, UUID newuuid) {
        Archive archive;
        block8: {
            URI uri = this.getEntryPoint(senderId).getArchiveDocumentByUUIDUri(uuid);
            Archive archive2 = this.getEntity(Archive.class, uri.getPath());
            ArchiveDocument document = archive2.getDocuments().get(0);
            URI addUniqeUUIDUri = document.getAddUniqueUUID();
            ArchiveDocument nyttDokument = new ArchiveDocument(newuuid, document.getFileName(), document.getFileType(), document.getContentType());
            CloseableHttpResponse response = this.sendDigipostMedia(nyttDokument, addUniqeUUIDUri.getPath());
            try {
                HttpResponseUtils.checkResponse((HttpResponse)response, this.eventLogger);
                archive2.getDocuments().addAll(JAXBContextUtils.unmarshal(JAXBContextUtils.jaxbContext, response.getEntity().getContent(), Archive.class).getDocuments());
                archive = archive2;
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new DigipostClientException(ErrorCode.GENERAL_ERROR, (Throwable)e);
                }
            }
            response.close();
        }
        return archive;
    }

    @Override
    public ArchiveDocument saveArchiveDocument(ArchiveDocument archiveDocument, URI uri) {
        HttpPut httpPut = new HttpPut(this.digipostUrl.resolve(uri.getPath()));
        httpPut.setHeader(Headers.Content_Type_DIGIPOST_MEDIA_TYPE_V8);
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        JAXBContextUtils.marshal(JAXBContextUtils.jaxbContext, archiveDocument, (OutputStream)bao);
        httpPut.setEntity((HttpEntity)new ByteArrayEntity(bao.toByteArray()));
        return this.requestEntity((HttpRequestBase)httpPut, ArchiveDocument.class);
    }

    @Override
    public Inbox getInbox(SenderId senderId, int offset, int limit) {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("offset", String.valueOf(offset));
        queryParams.put("limit", String.valueOf(limit));
        return this.getEntity(Inbox.class, this.getEntryPoint(senderId).getInboxUri().getPath(), queryParams);
    }

    @Override
    public InputStream getInboxDocumentContentStream(InboxDocument inboxDocument) {
        HttpGet httpGet = new HttpGet(inboxDocument.getContentUri());
        httpGet.setHeader("Accept", ContentType.WILDCARD.toString());
        HttpCoreContext httpCoreContext = HttpCoreContext.create();
        httpCoreContext.setAttribute("NOT_SIGNED_RESPONSE", (Object)true);
        return this.requestStream((HttpRequestBase)httpGet);
    }

    @Override
    public void deleteInboxDocument(InboxDocument inboxDocument) {
        this.send((HttpRequestBase)new HttpDelete(inboxDocument.getDeleteUri()));
    }

    @Override
    public UserAccount createOrActivateUserAccount(SenderId senderId, UserInformation user) {
        URI uri = this.getEntryPoint().getCreateOrActivateUserAccountUri();
        HttpPost httpPost = new HttpPost(uri);
        httpPost.setHeader(Headers.Content_Type_DIGIPOST_MEDIA_TYPE_V8);
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        JAXBContextUtils.marshal(JAXBContextUtils.jaxbContext, user, (OutputStream)bao);
        httpPost.setEntity((HttpEntity)new ByteArrayEntity(bao.toByteArray()));
        return this.requestEntity((HttpRequestBase)httpPost, UserAccount.class);
    }

    @Override
    public Batch createBatch(UUID batchUUID) {
        Batch batch;
        block8: {
            URI createBatch = this.getEntryPoint().getCreateBatch();
            CloseableHttpResponse response = this.sendDigipostMedia(new Batch(batchUUID.toString()), createBatch.toString());
            try {
                HttpResponseUtils.checkResponse((HttpResponse)response, this.eventLogger);
                batch = JAXBContextUtils.unmarshal(JAXBContextUtils.jaxbContext, response.getEntity().getContent(), Batch.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new DigipostClientException(ErrorCode.GENERAL_ERROR, (Throwable)e);
                }
            }
            response.close();
        }
        return batch;
    }

    @Override
    public Batch getBatchInformation(UUID batchUUID) {
        URI uri = this.getEntryPoint().getBatchByUUID(batchUUID);
        return this.getEntity(Batch.class, uri.getPath());
    }

    @Override
    public Batch completeBatch(Batch batch) {
        URI completeBatch = batch.getCompleteBatch();
        return this.requestEntity((HttpRequestBase)new HttpPost(completeBatch), Batch.class);
    }

    @Override
    public void cancelBatch(Batch batch) {
        this.send((HttpRequestBase)new HttpDelete(batch.getCancelBatch()));
    }

    @Override
    public void addTag(Tag tag) {
        URI uri = this.getEntryPoint().getAddTagUri();
        try (CloseableHttpResponse response = this.sendDigipostMedia(tag, uri.getPath());){
            HttpResponseUtils.checkResponse((HttpResponse)response, this.eventLogger);
        }
        catch (IOException e) {
            throw new DigipostClientException(ErrorCode.GENERAL_ERROR, (Throwable)e);
        }
    }

    @Override
    public void removeTag(Tag tag) {
        URI uri = this.getEntryPoint().getRemoveTagUri();
        try (CloseableHttpResponse response = this.sendDigipostMedia(tag, uri.getPath());){
            HttpResponseUtils.checkResponse((HttpResponse)response, this.eventLogger);
        }
        catch (IOException e) {
            throw new DigipostClientException(ErrorCode.GENERAL_ERROR, (Throwable)e);
        }
    }

    @Override
    public Tags getTags(PersonalIdentificationNumber personalIdentificationNumber) {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("personal-identification-number", personalIdentificationNumber.asString());
        return this.getEntity(Tags.class, this.getEntryPoint().getTagsUri().getPath(), queryParams);
    }

    @Override
    public ShareDocumentsRequestState getShareDocumentsRequestState(SenderId senderId, UUID shareDocumentsRequestUuid) {
        return this.getEntity(ShareDocumentsRequestState.class, this.getEntryPoint(senderId).getShareDocumentsRequestStateUri().getPath() + shareDocumentsRequestUuid.toString());
    }

    @Override
    public InputStream getSharedDocumentContentStream(URI uri) {
        HttpGet httpGet = new HttpGet(uri);
        httpGet.setHeader("Accept", ContentType.WILDCARD.toString());
        HttpCoreContext httpCoreContext = HttpCoreContext.create();
        httpCoreContext.setAttribute("NOT_SIGNED_RESPONSE", (Object)true);
        return this.requestStream((HttpRequestBase)httpGet);
    }

    @Override
    public SharedDocumentContent getSharedDocumentContent(URI uri) {
        return this.getEntity(SharedDocumentContent.class, uri.getPath());
    }

    @Override
    public CloseableHttpResponse stopSharing(SenderId senderId, URI uri) {
        ShareDocumentsRequestSharingStopped dataType = new ShareDocumentsRequestSharingStopped();
        AdditionalData data = AdditionalData.Builder.newAdditionalData((DataType)dataType).setSenderId(senderId).build();
        return this.addData(new AddDataLink(uri.getPath()), data);
    }

    private static String pathWithQuery(URI uri) {
        return uri.getPath() + (String)(uri.getQuery() != null ? "?" + uri.getQuery() : "");
    }

    private static URI createEncodedURIPath(String path) {
        try {
            return new URI(null, null, path, null);
        }
        catch (URISyntaxException e) {
            throw new DigipostClientException(ErrorCode.GENERAL_ERROR, "Error encoding search path because of " + ExceptionUtils.exceptionNameAndMessage(e), e);
        }
    }

    private <R> R getEntity(Class<R> entityType, String resourcePath) {
        return this.requestEntity((HttpRequestBase)new HttpGet(this.digipostUrl.resolve(resourcePath)), entityType);
    }

    private <R> R getEntity(Class<R> entityType, String resourcePath, Map<String, ?> queryParams) {
        HttpGet httpGet = new HttpGet(UriUtils.withQueryParams(this.digipostUrl.resolve(resourcePath), queryParams));
        return this.requestEntity((HttpRequestBase)httpGet, entityType);
    }

    private <R> InputStream requestStream(HttpRequestBase request) {
        return this.request(request, InputStream.class, new Header[0]);
    }

    private <R> R requestEntity(HttpRequestBase request, Class<R> entityType) {
        return this.request(request, entityType, Headers.Accept_DIGIPOST_MEDIA_TYPE_V8);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <R> R request(HttpRequestBase request, Class<R> entityType, Header ... headers) {
        for (Header header : headers) {
            request.setHeader(header);
        }
        if (entityType == InputStream.class) {
            InputStream responseStream = HttpResponseUtils.safelyOfferEntityStreamExternally(this.send(request), this.eventLogger);
            return (R)responseStream;
        }
        try (CloseableHttpResponse response = this.send(request);){
            HttpResponseUtils.checkResponse((HttpResponse)response, this.eventLogger);
            Object object = JAXB.unmarshal((InputStream)response.getEntity().getContent(), entityType);
            return (R)object;
        }
        catch (IOException e) {
            throw new DigipostClientException(ErrorCode.GENERAL_ERROR, e.getMessage(), e);
        }
    }

    private CloseableHttpResponse send(HttpRequestBase request) {
        return this.send(request, null);
    }

    private CloseableHttpResponse send(HttpRequestBase request, HttpContext context) {
        try {
            request.setHeader("X-Digipost-UserId", this.brokerId.stringValue());
            if (context == null) {
                return this.httpClient.execute((HttpUriRequest)request);
            }
            return this.httpClient.execute((HttpUriRequest)request, context);
        }
        catch (IOException e) {
            throw ExceptionUtils.asUnchecked(e);
        }
    }

    private CloseableHttpResponse sendDigipostMedia(Object data, String uri) {
        HttpPost httpPost = new HttpPost(this.digipostUrl.resolve(uri));
        httpPost.setHeader(Headers.Accept_DIGIPOST_MEDIA_TYPE_V8);
        httpPost.setHeader(Headers.Content_Type_DIGIPOST_MEDIA_TYPE_V8);
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        JAXBContextUtils.marshal(JAXBContextUtils.jaxbContext, data, (OutputStream)bao);
        httpPost.setEntity((HttpEntity)new ByteArrayEntity(bao.toByteArray()));
        return this.send((HttpRequestBase)httpPost);
    }
}

