/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.internal.http.request.interceptor;

import java.time.Clock;
import java.time.ZonedDateTime;
import no.digipost.api.client.EventLogger;
import no.digipost.api.client.util.DateUtils;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestDateInterceptor
implements HttpRequestInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(RequestDateInterceptor.class);
    private final EventLogger eventLogger;
    private final Clock clock;

    public RequestDateInterceptor(EventLogger eventLogger, Clock clock) {
        this.eventLogger = (eventLogger != null ? eventLogger : EventLogger.NOOP_LOGGER).withDebugLogTo(LOG);
        this.clock = clock;
    }

    public void process(HttpRequest httpRequest, HttpContext httpContext) {
        this.modifyRequest(httpRequest);
    }

    private void modifyRequest(HttpRequest httpRequest) {
        String dateOnRFC1123Format = DateUtils.formatDate(ZonedDateTime.now(this.clock));
        httpRequest.setHeader("Date", dateOnRFC1123Format);
        this.eventLogger.log(this.getClass().getSimpleName() + " satt headeren Date=" + dateOnRFC1123Format);
    }
}

